/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.task;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RPMineResetTasksConfig;
import joserodpt.realmines.api.mine.RMine;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MineResetTask {
    private final RealMinesAPI rm;
    private final String name;
    private final int delay;
    private final List<RMine> mines = new ArrayList<RMine>();
    private BukkitTask task;

    public MineResetTask(RealMinesAPI rm, String name, int delay, Boolean nova) {
        this.rm = rm;
        this.name = name;
        this.delay = delay;
        this.startTimer();
        if (nova.booleanValue()) {
            this.save();
        }
    }

    private void save() {
        RPMineResetTasksConfig.file().set(this.name + ".Delay", (Object)this.delay);
        RPMineResetTasksConfig.file().set(this.name + ".LinkedMines", this.mines.stream().map(RMine::getName).collect(Collectors.toList()));
        RPMineResetTasksConfig.save();
    }

    public void stopTimer() {
        if (!this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    public void startTimer() {
        this.task = new BukkitRunnable(){

            public void run() {
                MineResetTask.this.mines.forEach(RMine::reset);
            }
        }.runTaskTimer((Plugin)this.rm.getPlugin(), 0L, (long)this.delay * 20L);
    }

    public void addMine(RMine m) {
        this.mines.add(m);
        this.save();
    }

    public void removeMine(RMine m) {
        this.mines.remove(m);
        this.save();
    }

    public String getName() {
        return this.name;
    }

    public void clearLinks() {
        this.mines.clear();
    }

    public boolean hasMine(RMine mine) {
        return this.mines.contains(mine);
    }
}

