/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.task;

import java.util.Objects;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.utils.Countdown;

public class MineTimer {
    private Countdown count;
    private final RMine m;

    public MineTimer(RMine mi) {
        this.m = mi;
    }

    public void start() {
        this.startTask(this.m.getResetValue(RMine.Reset.TIME));
    }

    private void startTask(int s) {
        this.count = new Countdown(RealMinesAPI.getInstance().getPlugin(), s, () -> {}, () -> {
            this.m.reset(RMine.ResetCause.TIMER);
            this.startTask(this.m.getResetValue(RMine.Reset.TIME));
        }, t -> {
            if (RMConfig.file().getStringList("RealMines.announceTimes") != null && RMConfig.file().getStringList("RealMines.announceTimes").contains(String.valueOf(this.count.getSecondsLeft()))) {
                if (this.m.isSilent()) {
                    return;
                }
                this.m.broadcastMessage(TranslatableLine.MINE_RESET_WARNING.setV1(TranslatableLine.ReplacableVar.MINE.eq(this.m.getDisplayName())).setV2(TranslatableLine.ReplacableVar.TIME.eq(String.valueOf(this.count.getSecondsLeft()))).get());
            }
            if (this.m.getSigns().stream().anyMatch(mineSign -> Objects.equals(mineSign.getModifier(), "sl") || Objects.equals(mineSign.getModifier(), "tl"))) {
                this.m.updateSigns();
            }
        });
        this.count.scheduleTimer();
    }

    public void kill() {
        if (this.count != null) {
            this.count.killTask();
        }
    }

    public void restart() {
        this.kill();
        this.start();
    }

    public Countdown getCountdown() {
        return this.count;
    }
}

