/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.types;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.ArrayList;
import java.util.List;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.RMBlockSet;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.mine.components.items.MineBlockItem;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.utils.WorldEditUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BlockMine
extends RMine {
    private final List<Material> sorted = new ArrayList<Material>();

    public BlockMine(String name, World w, Location pos1, Location pos2) throws RMFailedToLoadException {
        super(name, w, pos1, pos2);
        this.fillContent();
        this.updateSigns();
    }

    public BlockMine(String name, Section mineConfigSection) throws RMFailedToLoadException {
        super(name, mineConfigSection);
        this.fillContent();
        this.updateSigns();
    }

    public BlockMine(String name, YamlConfiguration config) throws RMFailedToLoadException {
        super(name, config);
        if (!RMConfig.file().getBoolean("RealMines.disableMineResetOnServerStart", (Boolean)false).booleanValue()) {
            this.fillContent();
        }
        this.updateSigns();
    }

    @Override
    public void fillContent() {
        if (!super.getMineItems().isEmpty()) {
            if (RMConfig.file().getBoolean("RealMines.useWorldEditForBlockPlacement").booleanValue()) {
                try {
                    RandomPattern randomPattern = new RandomPattern();
                    super.getMineItems().values().stream().filter(mineItem -> mineItem.getPercentage() > 0.0).forEach(mineBlock -> randomPattern.add((Pattern)BukkitAdapter.adapt((BlockData)mineBlock.getMaterial().createBlockData()).toBaseBlock(), mineBlock.getPercentage()));
                    BlockVector3 point1 = BlockVector3.at((double)this.getMineCuboid().getPOS1().getX(), (double)this.getMineCuboid().getPOS1().getY(), (double)this.getMineCuboid().getPOS1().getZ());
                    BlockVector3 point2 = BlockVector3.at((double)this.getMineCuboid().getPOS2().getX(), (double)this.getMineCuboid().getPOS2().getY(), (double)this.getMineCuboid().getPOS2().getZ());
                    WorldEditUtils.setBlocks((Region)new CuboidRegion(BukkitAdapter.adapt((World)this.getWorld()), point1, point2), (Pattern)randomPattern);
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("Error while setting blocks for mine: " + this.getName());
                    Bukkit.getLogger().warning("Error: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                this.sortBlocks();
                if (!super.getMineItems().isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)RealMinesAPI.getInstance().getPlugin(), () -> {
                        for (Block block : this.getMineCuboid()) {
                            Material set = this.getBlock();
                            if (block.getType() == set) continue;
                            block.setType(set);
                        }
                    });
                }
            }
        }
        super.fillFaces();
    }

    @Override
    public RMine.Type getType() {
        return RMine.Type.BLOCKS;
    }

    private void sortBlocks() {
        this.sorted.clear();
        for (MineItem d : super.getMineItems().values()) {
            double percentage = d.getPercentage() * (double)this.getBlockCount();
            for (int i = 0; i <= (int)percentage; ++i) {
                if (this.sorted.size() == this.getBlockCount()) continue;
                this.sorted.add(d.getMaterial());
            }
        }
    }

    private Material getBlock() {
        Material m;
        if (!this.sorted.isEmpty()) {
            m = this.sorted.get(RealMinesAPI.getRand().nextInt(this.sorted.size()));
            this.sorted.remove(m);
        } else {
            m = Material.AIR;
        }
        return m;
    }

    public void removeMineBlockItem(String blockSetKey, MineItem mb) {
        super.getBlockSet(blockSetKey).remove(mb);
        this.saveData(RMine.MineData.BLOCKS);
    }

    public void addItem(String blockSetKey, MineBlockItem mineBlock) {
        RMBlockSet blockSet = this.getBlockSet(blockSetKey);
        if (blockSet != null && !blockSet.contains(mineBlock)) {
            blockSet.add(mineBlock);
            this.saveData(RMine.MineData.BLOCKS);
        }
    }

    @Override
    public void clearContents() {
        if (RMConfig.file().getBoolean("RealMines.useWorldEditForBlockPlacement").booleanValue()) {
            BlockVector3 point1 = BlockVector3.at((double)this.getMineCuboid().getPOS1().getX(), (double)this.getMineCuboid().getPOS1().getY(), (double)this.getMineCuboid().getPOS1().getZ());
            BlockVector3 point2 = BlockVector3.at((double)this.getMineCuboid().getPOS2().getX(), (double)this.getMineCuboid().getPOS2().getY(), (double)this.getMineCuboid().getPOS2().getZ());
            WorldEditUtils.setBlocks((Region)new CuboidRegion(BukkitAdapter.adapt((World)this.getWorld()), point1, point2), (Pattern)BukkitAdapter.adapt((BlockData)Material.AIR.createBlockData()));
        } else {
            this.getMineCuboid().clear();
        }
    }
}

