/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.types;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.RMBlockSet;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.mine.components.items.MineSchematicItem;
import joserodpt.realmines.api.utils.WorldEditUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;

public class SchematicMine
extends RMine {
    private String schematicFile;
    private Clipboard pasteClipboard;

    public SchematicMine(String name, Section mineConfigSection) throws RMFailedToLoadException {
        super(name, mineConfigSection);
        this.schematicFile = mineConfigSection.getString("Schematic-Filename");
        this.pasteClipboard = this.loadSchematic(this.schematicFile);
        this.fillContent();
        this.processPastedBlocks();
        this.updateSigns();
    }

    public SchematicMine(String name, YamlConfiguration config) throws RMFailedToLoadException {
        super(name, config);
        this.schematicFile = config.getString("schematic");
        this.pasteClipboard = this.loadSchematic(this.schematicFile);
        if (!RMConfig.file().getBoolean("RealMines.disableMineResetOnServerStart", (Boolean)false).booleanValue()) {
            this.fillContent();
            this.processPastedBlocks();
        }
        this.updateSigns();
    }

    public SchematicMine(String name, Location l, String schematicFile) throws RMFailedToLoadException {
        super(name, l.getWorld());
        this.schematicFile = schematicFile;
        this.getMineConfig().set("schematic", (Object)schematicFile);
        this.setPOS(l, null);
        this.saveConfig();
        this.pasteClipboard = this.loadSchematic(schematicFile);
        this.fillContent();
        this.processPastedBlocks();
        this.updateSigns();
    }

    private void processPastedBlocks() {
        RMBlockSet defaultBlockSet = this.getBlockSet("default");
        if (defaultBlockSet == null) {
            defaultBlockSet = this.addBlockSet("default");
        }
        if (defaultBlockSet.getItems().isEmpty()) {
            for (Block block : this.getMineCuboid()) {
                Material type = block.getType();
                if (type == Material.AIR) continue;
                defaultBlockSet.add(new MineSchematicItem(type));
            }
            this.saveData(RMine.MineData.BLOCKS);
        }
    }

    @Override
    public List<MineItem> getBlockIcons(String blockSet) {
        this.processPastedBlocks();
        return super.getBlockIcons(blockSet);
    }

    @Override
    public void fillContent() {
        this.placeSchematic(this.pasteClipboard, this.getPOS1());
        super.fillFaces();
    }

    @Override
    public RMine.Type getType() {
        return RMine.Type.SCHEMATIC;
    }

    public String getSchematicFilename() {
        return this.schematicFile;
    }

    public Clipboard loadSchematic(String name) {
        File folder = new File(RealMinesAPI.getInstance().getMineManager().getSchematicFolder(), "schematics");
        File file = new File(folder, name);
        Clipboard clipboard = null;
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        try (ClipboardReader reader = format.getReader(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            clipboard = reader.read();
        }
        catch (IOException e) {
            RealMinesAPI.getInstance().getPlugin().getLogger().severe("Failed to load schematic named " + name);
            RealMinesAPI.getInstance().getPlugin().getLogger().severe(e.getMessage());
        }
        return clipboard;
    }

    public void placeSchematic(Clipboard clipboard, Location loc) {
        if (clipboard != null) {
            try {
                EditSession editSession = WorldEdit.getInstance().newEditSession(BukkitAdapter.adapt((World)loc.getWorld()));
                ClipboardHolder holder = new ClipboardHolder(clipboard);
                Region region = clipboard.getRegion();
                BlockVector3 to = BlockVector3.at((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
                Operation operation = holder.createPaste((Extent)editSession).to(to).ignoreAirBlocks(RMConfig.file().getBoolean("RealMines.ignoreAirBlocksSchematicPasting", (Boolean)true).booleanValue()).copyBiomes(false).copyEntities(false).build();
                Operations.completeLegacy((Operation)operation);
                editSession.flushSession();
                BlockVector3 clipboardOffset = clipboard.getRegion().getMinimumPoint().subtract(clipboard.getOrigin());
                Vector3 min = to.toVector3().add(holder.getTransform().apply(clipboardOffset.toVector3()));
                Vector3 max = min.add(holder.getTransform().apply(region.getMaximumPoint().subtract(region.getMinimumPoint()).toVector3()));
                this.setPOS(WorldEditUtils.toLocation(min, this.getWorld()), WorldEditUtils.toLocation(max, this.getWorld()));
            }
            catch (Exception e) {
                RealMinesAPI.getInstance().getPlugin().getLogger().severe("Failed to paste schematic named: " + this.name + " is the schematic too big? Is WorldEdit/FAWE properly enabled and supported?");
                RealMinesAPI.getInstance().getPlugin().getLogger().severe(e.getMessage());
            }
        }
    }

    @Override
    public void clearContents() {
        if (RMConfig.file().getBoolean("RealMines.useWorldEditForBlockPlacement").booleanValue()) {
            BlockVector3 point1 = BlockVector3.at((double)this.getMineCuboid().getPOS1().getX(), (double)this.getMineCuboid().getPOS1().getY(), (double)this.getMineCuboid().getPOS1().getZ());
            BlockVector3 point2 = BlockVector3.at((double)this.getMineCuboid().getPOS2().getX(), (double)this.getMineCuboid().getPOS2().getY(), (double)this.getMineCuboid().getPOS2().getZ());
            WorldEditUtils.setBlocks((Region)new CuboidRegion(BukkitAdapter.adapt((World)this.getWorld()), point1, point2), (Pattern)BukkitAdapter.adapt((BlockData)Material.AIR.createBlockData()));
        } else {
            this.getMineCuboid().clear();
        }
    }
}

