/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.types.farm;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joserodpt.realmines.api.mine.components.items.farm.FarmItemGrowth;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public enum FarmItem {
    WHEAT(Material.WHEAT, Material.WHEAT, Material.FARMLAND, new FarmItemGrowth(0, 7), false, true),
    CARROT(Material.CARROT, Material.CARROTS, Material.FARMLAND, new FarmItemGrowth(0, 7), false, true),
    POTATO(Material.POTATO, Material.POTATOES, Material.FARMLAND, new FarmItemGrowth(0, 7), false, true),
    BEETROOT(Material.BEETROOT, Material.BEETROOTS, Material.FARMLAND, new FarmItemGrowth(0, 3), false, true),
    MELON_SEED(Material.MELON, Material.MELON_STEM, Material.FARMLAND, new FarmItemGrowth(0, 7), false, false),
    PUMPKIN_SEED(Material.PUMPKIN, Material.PUMPKIN_STEM, Material.FARMLAND, new FarmItemGrowth(0, 7), false, false),
    NETHER_WART(Material.NETHER_WART, Material.SOUL_SAND, new FarmItemGrowth(0, 3), false, true),
    SUGAR_CANE(Material.SUGAR_CANE, Material.GRASS_BLOCK, true, false),
    CACTUS(Material.CACTUS, Material.SAND, true, false),
    AIR(Material.AIR);

    private final Material icon;
    private final Material crop;
    private final Material underMaterial;
    private final FarmItemGrowth fig;
    private final Boolean needsWaterNearby;
    private final Boolean canHaveNeighbours;

    private FarmItem(Material icon, Material crop, Material underMaterial, FarmItemGrowth fie, boolean needsWaterNearby, boolean canHaveNeighbours) {
        this.icon = icon;
        this.crop = crop;
        this.underMaterial = underMaterial;
        this.needsWaterNearby = needsWaterNearby;
        this.canHaveNeighbours = canHaveNeighbours;
        this.fig = fie;
    }

    private FarmItem(Material crop, Material underMaterial, FarmItemGrowth fie, boolean needsWaterNearby, boolean canHaveNeighbours) {
        this.icon = crop;
        this.crop = crop;
        this.underMaterial = underMaterial;
        this.needsWaterNearby = needsWaterNearby;
        this.canHaveNeighbours = canHaveNeighbours;
        this.fig = fie;
    }

    private FarmItem(Material crop, Material underMaterial, boolean needsWaterNearby, boolean canHaveNeighbours) {
        this.icon = crop;
        this.crop = crop;
        this.underMaterial = underMaterial;
        this.needsWaterNearby = needsWaterNearby;
        this.canHaveNeighbours = canHaveNeighbours;
        this.fig = null;
    }

    public static Material findIconForCrop(Material m) {
        return Arrays.stream(FarmItem.values()).filter(fi -> fi.getCrop().equals((Object)m)).map(FarmItem::getIcon).findFirst().orElse(null);
    }

    private FarmItem(Material crop) {
        this.icon = crop;
        this.crop = crop;
        this.underMaterial = crop;
        this.needsWaterNearby = true;
        this.canHaveNeighbours = true;
        this.fig = null;
    }

    public static List<Material> getIcons() {
        return Arrays.stream(FarmItem.values()).map(FarmItem::getIcon).collect(Collectors.toList());
    }

    public static List<Material> getCrops() {
        return Arrays.stream(FarmItem.values()).map(FarmItem::getCrop).collect(Collectors.toList());
    }

    public static Material getIconFromCrop(Material cropMaterial) {
        return Arrays.stream(FarmItem.values()).filter(fi -> fi.getCrop().equals((Object)cropMaterial)).map(FarmItem::getIcon).findFirst().orElse(Material.AIR);
    }

    public Material getIcon() {
        return this.icon;
    }

    public Material getCrop() {
        return this.crop;
    }

    public Material getUnderMaterial() {
        return this.underMaterial;
    }

    public FarmItemGrowth getFarmItemGrowth() {
        return this.fig;
    }

    public static FarmItem valueOf(Material icon) {
        return Arrays.stream(FarmItem.values()).filter(value -> value.getIcon().equals((Object)icon)).findFirst().orElse(null);
    }

    public Boolean needsWaterNearby() {
        return this.needsWaterNearby;
    }

    public Boolean canHaveNeighbours() {
        return this.canHaveNeighbours;
    }

    public boolean canBePlaced(Block block, Block under) {
        if (!this.canHaveNeighbours().booleanValue()) {
            if (Stream.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST).map(arg_0 -> ((Block)block).getRelative(arg_0)).map(Block::getType).noneMatch(type -> type == Material.AIR)) {
                return false;
            }
        }
        if (!this.needsWaterNearby().booleanValue()) {
            return true;
        }
        return Stream.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST).map(arg_0 -> ((Block)under).getRelative(arg_0)).map(Block::getType).anyMatch(type -> type == Material.WATER);
    }
}

