/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.types.farm;

import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.MineCuboid;
import joserodpt.realmines.api.mine.components.RMBlockSet;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.mine.components.items.farm.MineFarmItem;
import joserodpt.realmines.api.mine.types.farm.FarmItem;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FarmMine
extends RMine {
    private final List<MineItem> sorted = new ArrayList<MineItem>();
    private List<Block> mineGroundBlocks = new ArrayList<Block>();

    public FarmMine(String name, World w, Location pos1, Location pos2) throws RMFailedToLoadException {
        super(name, w, pos1, pos2);
        this.fillContent();
        this.updateSigns();
    }

    public FarmMine(String name, Section mineConfigSection) throws RMFailedToLoadException {
        super(name, mineConfigSection);
        this.fillContent();
        this.updateSigns();
    }

    public FarmMine(String name, YamlConfiguration config) throws RMFailedToLoadException {
        super(name, config);
        if (!RMConfig.file().getBoolean("RealMines.disableMineResetOnServerStart", (Boolean)false).booleanValue()) {
            this.fillContent();
        }
        this.updateSigns();
    }

    @Override
    public void setPOS(Location p1, Location p2) {
        super.setPOS(p1, p2);
        this.checkFarmBlocks();
    }

    private void checkFarmBlocks() {
        if (!this.oneBlockHeight()) {
            this.mineGroundBlocks.clear();
            ArrayList<Block> underBlocks = new ArrayList<Block>(this.getMineCuboid().getFace(MineCuboid.CuboidDirection.Down).getBlocks());
            while (!underBlocks.isEmpty()) {
                Block block = (Block)underBlocks.get(0);
                Material upMat = block.getRelative(BlockFace.UP).getType();
                if (block.getType() != Material.WATER && (upMat == Material.AIR || upMat == Material.GRASS || upMat == Material.TALL_GRASS || FarmItem.getCrops().contains(upMat))) {
                    this.mineGroundBlocks.add(block);
                } else if (block.getType() != Material.WATER) {
                    underBlocks.add(block.getRelative(BlockFace.UP));
                }
                underBlocks.remove(block);
            }
        }
    }

    @Override
    public void clearContents() {
        if (this.oneBlockHeight()) {
            this.getMineCuboid().clear();
        } else {
            this.mineGroundBlocks.forEach(block -> block.getRelative(BlockFace.UP).setType(Material.AIR));
        }
    }

    @Override
    public void fillContent() {
        if (this.sorted == null) {
            return;
        }
        this.sortCrops();
        if (!super.getMineItems().isEmpty()) {
            Bukkit.getScheduler().runTask((Plugin)RealMinesAPI.getInstance().getPlugin(), () -> {
                if (this.oneBlockHeight()) {
                    for (Block target : this.getMineCuboid()) {
                        MineFarmItem fi = this.getFarmBlock();
                        Block under = target.getRelative(BlockFace.DOWN);
                        this.placeFarmItems(target, under, fi);
                    }
                } else {
                    for (Block under : this.mineGroundBlocks) {
                        Block target = under.getRelative(BlockFace.UP);
                        MineFarmItem fi = this.getFarmBlock();
                        this.placeFarmItems(target, under, fi);
                    }
                }
            });
        }
        super.fillFaces();
    }

    private void placeFarmItems(Block target, Block under, MineFarmItem fi) {
        if (fi.getMaterial() != Material.AIR && fi.getFarmItem().canBePlaced(target, under) && under.getType() != Material.WATER) {
            BlockData data;
            boolean placeFarmLandBelowCrop = fi.getFarmItem().canBePlaced(target, under);
            Material underMat = fi.getFarmItem().getUnderMaterial();
            if (placeFarmLandBelowCrop && under.getType() != underMat) {
                under.setType(underMat);
            }
            Material mat = fi.getFarmItem().getCrop();
            if (target.getType() != mat) {
                target.setType(mat);
            }
            if ((data = target.getBlockData()) instanceof Ageable) {
                Ageable ag = (Ageable)data;
                ag.setAge(fi.getAge());
                target.setBlockData((BlockData)ag);
            }
        }
    }

    private boolean oneBlockHeight() {
        return this.getPOS1().getY() == this.getPOS2().getY();
    }

    @Override
    public RMine.Type getType() {
        return RMine.Type.FARM;
    }

    private void sortCrops() {
        this.sorted.clear();
        for (MineItem d : super.getMineItems().values()) {
            double percentage = d.getPercentage() * (double)this.getBlockCount();
            for (int i = 0; i <= (int)percentage; ++i) {
                if (this.sorted.size() == this.getBlockCount()) continue;
                this.sorted.add(d);
            }
        }
    }

    private MineFarmItem getFarmBlock() {
        if (!this.sorted.isEmpty()) {
            int randomIndex = new Random().nextInt(this.sorted.size());
            return (MineFarmItem)this.sorted.remove(randomIndex);
        }
        return new MineFarmItem();
    }

    public void removeMineFarmItem(String blockSetKey, MineItem mb) {
        super.getBlockSet(blockSetKey).remove(mb);
        this.saveData(RMine.MineData.BLOCKS);
    }

    public void addFarmItem(String blockSetKey, MineFarmItem mineFarmItem) {
        RMBlockSet blockSet = this.getBlockSet(blockSetKey);
        if (blockSet != null && !blockSet.contains(mineFarmItem)) {
            blockSet.add(mineFarmItem);
            this.saveData(RMine.MineData.BLOCKS);
        }
    }
}

