/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils;

import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Countdown
implements Runnable {
    private final JavaPlugin plugin;
    private Integer assignedTaskId;
    private final int seconds;
    private int secondsLeft;
    private final Consumer<Countdown> everySecond;
    private final Runnable beforeTimer;
    private final Runnable afterTimer;

    public Countdown(JavaPlugin plugin, int seconds, Runnable beforeTimer, Runnable afterTimer, Consumer<Countdown> everySecond) {
        this.plugin = plugin;
        this.seconds = seconds;
        this.secondsLeft = seconds;
        this.beforeTimer = beforeTimer;
        this.afterTimer = afterTimer;
        this.everySecond = everySecond;
    }

    public static String format(long mills) {
        long seconds = mills / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        StringBuilder formattedTime = new StringBuilder();
        if (days > 0L) {
            formattedTime.append(days).append("d ");
        }
        if (hours > 0L) {
            formattedTime.append(hours).append("h ");
        }
        if (minutes > 0L) {
            formattedTime.append(minutes).append("m ");
        }
        if (seconds > 0L || mills > 0L && formattedTime.length() == 0) {
            formattedTime.append(seconds).append("s");
        }
        return formattedTime.toString().trim();
    }

    @Override
    public void run() {
        if (this.secondsLeft < 1) {
            this.afterTimer.run();
            if (this.assignedTaskId != null) {
                Bukkit.getScheduler().cancelTask(this.assignedTaskId.intValue());
            }
            return;
        }
        if (this.secondsLeft == this.seconds) {
            this.beforeTimer.run();
        }
        this.everySecond.accept(this);
        --this.secondsLeft;
    }

    public int getTotalSeconds() {
        return this.seconds;
    }

    public int getSecondsLeft() {
        return this.secondsLeft;
    }

    public void setSecondsLeft(int secondsLeft) {
        this.secondsLeft = secondsLeft;
    }

    public Integer getTaskId() {
        return this.assignedTaskId;
    }

    public void killTask() {
        Bukkit.getScheduler().cancelTask(this.assignedTaskId.intValue());
    }

    public void scheduleTimer() {
        this.assignedTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 0L, 20L);
    }
}

