/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIBuilder {
    private static final Map<UUID, GUIBuilder> inventories = new HashMap<UUID, GUIBuilder>();
    private Inventory inv;
    private final Map<Integer, ClickRunnable> runnables = new HashMap<Integer, ClickRunnable>();
    private final UUID uuid;

    public GUIBuilder(String name, int size, UUID uuid) {
        this(Text.color(name), size, uuid, null);
    }

    public GUIBuilder(String name, int size, UUID uuid, ItemStack placeholder) {
        this.uuid = uuid;
        if (size == 0) {
            return;
        }
        this.inv = Bukkit.createInventory(null, (int)size, (String)Text.color(name));
        if (placeholder != null) {
            for (int i = 0; i < size; ++i) {
                this.inv.setItem(i, placeholder);
            }
        }
        this.register();
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                HumanEntity clicker = e.getWhoClicked();
                if (clicker instanceof Player) {
                    UUID uuid;
                    if (e.getCurrentItem() == null) {
                        return;
                    }
                    Player p = (Player)clicker;
                    if (p != null && inventories.containsKey(uuid = p.getUniqueId())) {
                        GUIBuilder current = inventories.get(uuid);
                        if (!e.getInventory().getType().name().equalsIgnoreCase(current.getInventory().getType().name())) {
                            return;
                        }
                        e.setCancelled(true);
                        int slot = e.getSlot();
                        if (current.runnables.get(slot) != null) {
                            current.runnables.get(slot).run(e);
                        }
                    }
                }
            }

            @EventHandler
            public void onClose(InventoryCloseEvent e) {
                if (e.getPlayer() instanceof Player) {
                    if (e.getInventory() == null) {
                        return;
                    }
                    Player p = (Player)e.getPlayer();
                    UUID uuid = p.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        inventories.get(uuid).unRegister();
                    }
                }
            }
        };
    }

    public static ItemStack placeholder(DyeColor d, String n) {
        ItemStack placeholder = new ItemStack(Material.WHITE_STAINED_GLASS_PANE, 1, (short)d.getDyeData());
        ItemMeta placeholdermeta = placeholder.getItemMeta();
        placeholdermeta.setDisplayName(n);
        placeholder.setItemMeta(placeholdermeta);
        return placeholder;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public int getSize() {
        return this.inv.getSize();
    }

    public void setItem(ItemStack is, Integer slot, ClickRunnable executeOnClick) {
        this.inv.setItem(slot.intValue(), is);
        this.runnables.put(slot, executeOnClick);
    }

    public void setItem(ClickRunnable executeOnClick, ItemStack itemstack, Integer slot) {
        ItemMeta im = itemstack.getItemMeta();
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_UNBREAKABLE});
        this.inv.setItem(slot.intValue(), itemstack);
        this.runnables.put(slot, executeOnClick);
    }

    public void removeItem(int slot) {
        this.inv.setItem(slot, new ItemStack(Material.AIR));
    }

    public void setItem(ItemStack itemstack, Integer slot) {
        this.inv.setItem(slot.intValue(), itemstack);
    }

    public void openInventory(Player player) {
        Inventory inv = this.getInventory();
        InventoryView openInv = player.getOpenInventory();
        if (openInv != null) {
            Inventory openTop = player.getOpenInventory().getTopInventory();
            if (openTop != null && openTop.getType().name().equalsIgnoreCase(inv.getType().name())) {
                openTop.setContents(inv.getContents());
            } else {
                player.openInventory(inv);
            }
            this.register();
        }
    }

    private void register() {
        inventories.put(this.uuid, this);
    }

    private void unRegister() {
        inventories.remove(this.uuid);
    }

    public void addItem(ClickRunnable clickRunnable, ItemStack i, int slot) {
        ItemMeta im = i.getItemMeta();
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_UNBREAKABLE});
        this.inv.setItem(slot, i);
        this.runnables.put(slot, clickRunnable);
    }

    @FunctionalInterface
    public static interface CloseRunnable {
        public void run(InventoryCloseEvent var1);
    }

    @FunctionalInterface
    public static interface ClickRunnable {
        public void run(InventoryClickEvent var1);
    }
}

