/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class ItemStackSpringer {
    private static final Gson gson = new Gson();

    public static String getItemSerializedJSON(ItemStack i) {
        return gson.toJson(ItemStackSpringer.getItemSerialized(i));
    }

    public static ItemStack getItemDeSerializedJSON(String s) {
        return ItemStackSpringer.getItemDeSerialized((Map)gson.fromJson(s, HashMap.class));
    }

    public static Map<String, Object> getItemSerialized(ItemStack i) {
        return ItemStackSpringer.getItemSerialized(-1, i);
    }

    public static Map<String, Object> getItemSerialized(int slot, ItemStack i) {
        PotionMeta potionMeta;
        FireworkMeta fireworkMeta;
        BookMeta bookMeta;
        BannerMeta bannerMeta;
        Damageable damageable;
        HashMap<String, Object> singleItem = new HashMap<String, Object>();
        if (i == null) {
            singleItem.put(ItemCategories.EMPTY.name(), ItemCategories.EMPTY.name());
            return singleItem;
        }
        if (slot != -1) {
            singleItem.put(ItemCategories.SLOT.name(), slot);
        }
        if (i.getItemMeta() instanceof Damageable && (damageable = (Damageable)i.getItemMeta()).hasDamage()) {
            int damage = damageable.getDamage();
            singleItem.put(ItemCategories.DAMAGE.name(), damage);
        }
        if (i.hasItemMeta()) {
            if (i.getItemMeta().hasDisplayName()) {
                singleItem.put(ItemCategories.NAME.name(), i.getItemMeta().getDisplayName());
            }
            if (i.getItemMeta().hasLore()) {
                singleItem.put(ItemCategories.LORE.name(), i.getItemMeta().getLore());
            }
            if (i.getItemMeta().hasEnchants()) {
                singleItem.put(ItemCategories.ENCHANTMENTS.name(), i.getEnchantments().entrySet().stream().map(entry -> ((Enchantment)entry.getKey()).getKey().getKey() + ":" + String.valueOf(entry.getValue())).collect(Collectors.joining(";")));
            }
            if (!i.getItemMeta().getItemFlags().isEmpty()) {
                singleItem.put(ItemCategories.ITEM_FLAGS.name(), i.getItemMeta().getItemFlags().stream().map(Enum::name).collect(Collectors.joining(";")));
            }
            if (i.getItemMeta().hasAttributeModifiers()) {
                HashMap<String, Map<String, Object>> attributes = new HashMap<String, Map<String, Object>>();
                for (Attribute attribute : i.getItemMeta().getAttributeModifiers().keySet()) {
                    attributes.put(attribute.name(), i.getItemMeta().getAttributeModifiers(attribute).stream().collect(Collectors.toMap(AttributeModifier::getName, AttributeModifier::serialize)));
                }
                if (!attributes.isEmpty()) {
                    singleItem.put(ItemCategories.ITEM_ATTRIBUTES.name(), attributes);
                }
            }
        }
        if (i.getType().name().contains("LEATHER_")) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)i.getItemMeta();
            Color armorColor = leatherArmorMeta.getColor();
            singleItem.put(ItemCategories.LEATHER_ARMOR_COLOR.name(), armorColor.asRGB());
        }
        if (i.getType().name().contains("_BANNER") && !(bannerMeta = (BannerMeta)i.getItemMeta()).getPatterns().isEmpty()) {
            List patternsSave = bannerMeta.getPatterns().stream().map(Pattern::serialize).collect(Collectors.toList());
            singleItem.put(ItemCategories.BANNER_PATTERNS.name(), patternsSave);
        }
        if ((i.getType() == Material.WRITABLE_BOOK || i.getType() == Material.WRITTEN_BOOK) && (bookMeta = (BookMeta)i.getItemMeta()) != null) {
            HashMap<String, Object> book_data = new HashMap<String, Object>();
            if (bookMeta.hasAuthor()) {
                book_data.put("author", bookMeta.getAuthor());
            }
            if (bookMeta.hasTitle()) {
                book_data.put("title", bookMeta.getTitle());
            }
            if (bookMeta.hasPages()) {
                book_data.put("pages", bookMeta.getPages());
            }
            singleItem.put(ItemCategories.BOOK_DATA.name(), book_data);
        }
        if (i.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)i.getItemMeta();
            singleItem.put(ItemCategories.BOOK_ENCHANTMENTS.name(), meta.getStoredEnchants().entrySet().stream().map(entry -> ((Enchantment)entry.getKey()).getKey().getKey() + ":" + String.valueOf(entry.getValue())).collect(Collectors.joining(";")));
        }
        if (i.getType() == Material.FIREWORK_ROCKET && (fireworkMeta = (FireworkMeta)i.getItemMeta()) != null) {
            HashMap<String, Object> firework_data = new HashMap<String, Object>();
            firework_data.put("power", fireworkMeta.getPower());
            if (fireworkMeta.hasEffects()) {
                List effects_serialized = fireworkMeta.getEffects().stream().map(ItemStackSpringer::serializeFirework).collect(Collectors.toList());
                firework_data.put("effects", effects_serialized);
            }
            singleItem.put(ItemCategories.FIREWORK_DATA.name(), firework_data);
        }
        if ((i.getType() == Material.POTION || i.getType() == Material.LINGERING_POTION || i.getType() == Material.SPLASH_POTION) && (potionMeta = (PotionMeta)i.getItemMeta()) != null) {
            singleItem.put(ItemCategories.POTION_DATA.name(), ItemStackSpringer.serializePotionData(potionMeta.getBasePotionData()));
        }
        singleItem.put(ItemCategories.MATERIAL.name(), i.getType().name());
        singleItem.put(ItemCategories.AMOUNT.name(), i.getAmount());
        return singleItem;
    }

    public static Map<String, Object> serializePotionData(PotionData potionData) {
        return ImmutableMap.of((Object)"type", (Object)potionData.getType().name(), (Object)"extended", (Object)potionData.isExtended(), (Object)"upgraded", (Object)potionData.isUpgraded());
    }

    public static PotionData deserializePotionData(Map<String, Object> data) {
        if (data.containsKey("type") && data.containsKey("extended") && data.containsKey("upgraded")) {
            PotionType type = PotionType.valueOf((String)((String)data.get("type")));
            boolean extended = (Boolean)data.get("extended");
            boolean upgraded = (Boolean)data.get("upgraded");
            return new PotionData(type, extended, upgraded);
        }
        return null;
    }

    public static ItemStack getItemDeSerialized(Map<String, Object> data) {
        int amount;
        ItemStackSpringer.debugPrint(ItemStackSpringer.class, "Attempting to deserialize Item with Data " + data.toString());
        if (!data.containsKey(ItemCategories.MATERIAL.name())) {
            return null;
        }
        ItemStackSpringer.debugPrint(ItemStackSpringer.class, "Attempting to deserialize Item Data of Material " + String.valueOf(data.get(ItemCategories.MATERIAL.name())));
        Material m = Material.valueOf((String)((String)data.get(ItemCategories.MATERIAL.name())));
        try {
            amount = (Integer)data.get(ItemCategories.AMOUNT.name());
        }
        catch (Exception e) {
            try {
                amount = (int)((Double)data.get(ItemCategories.AMOUNT.name())).doubleValue();
            }
            catch (Exception e2) {
                amount = 1;
                RealMinesAPI.getInstance().getPlugin().getLogger().severe("Could not load item amount for " + m.name() + " - defaulting to 1");
                e2.printStackTrace();
            }
        }
        ItemStack i = new ItemStack(m, amount);
        for (Map.Entry<String, Object> par : data.entrySet()) {
            ItemMeta meta = i.getItemMeta();
            String key = par.getKey();
            Object value = par.getValue();
            if (ItemCategories.NAME.name().equals(key)) {
                meta.setDisplayName(Text.color((String)value));
                i.setItemMeta(meta);
            }
            if (ItemCategories.LORE.name().equals(key)) {
                meta.setLore(Text.color((List)value));
                i.setItemMeta(meta);
            }
            if (ItemCategories.DAMAGE.name().equals(key)) {
                Damageable damageable = (Damageable)i.getItemMeta();
                int newDamageValue = (Integer)value;
                damageable.setDamage(newDamageValue);
                i.setItemMeta((ItemMeta)damageable);
            }
            if (ItemCategories.ENCHANTMENTS.name().equals(key)) {
                String[] enchantments;
                for (String enchantmentEntry : enchantments = value.toString().split(";")) {
                    int enchantmentLevel;
                    String[] parts = enchantmentEntry.split(":");
                    if (parts.length != 2) continue;
                    String enchantmentName = parts[0];
                    try {
                        enchantmentLevel = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    Enchantment enchantment = ItemStackSpringer.getEnchantmentByName(enchantmentName);
                    ItemStackSpringer.debugPrint(ItemStackSpringer.class, "Trying to apply " + enchantmentName + " - " + enchantmentLevel);
                    if (enchantment == null) continue;
                    i.addUnsafeEnchantment(enchantment, enchantmentLevel);
                }
            }
            if (ItemCategories.ITEM_FLAGS.name().equals(key)) {
                String[] flags;
                for (String flagName : flags = value.toString().split(";")) {
                    try {
                        ItemFlag flag = ItemFlag.valueOf((String)flagName);
                        assert (meta != null);
                        meta.addItemFlags(new ItemFlag[]{flag});
                        i.setItemMeta(meta);
                    }
                    catch (IllegalArgumentException e) {
                        RealMinesAPI.getInstance().getPlugin().getLogger().severe(flagName + " isn't a known ItemFlag (is this a bug?) Skipping this flag.");
                    }
                }
            }
            if (ItemCategories.LEATHER_ARMOR_COLOR.name().equals(key)) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)i.getItemMeta();
                leatherArmorMeta.setColor(Color.fromRGB((int)((Integer)value)));
                i.setItemMeta((ItemMeta)leatherArmorMeta);
            }
            if (ItemCategories.BANNER_PATTERNS.name().equals(key)) {
                BannerMeta bannerMeta = (BannerMeta)i.getItemMeta();
                List patternData = (List)value;
                bannerMeta.setPatterns(patternData.stream().map(Pattern::new).collect(Collectors.toList()));
                i.setItemMeta((ItemMeta)bannerMeta);
            }
            if (ItemCategories.BOOK_DATA.name().equals(key)) {
                BookMeta bookMeta = (BookMeta)i.getItemMeta();
                Map book_data = (Map)value;
                if (book_data.containsKey("author")) {
                    bookMeta.setAuthor((String)book_data.get("author"));
                }
                if (book_data.containsKey("title")) {
                    bookMeta.setTitle((String)book_data.get("title"));
                }
                if (book_data.containsKey("pages")) {
                    bookMeta.setPages((List)book_data.get("pages"));
                }
                i.setItemMeta((ItemMeta)bookMeta);
            }
            if (ItemCategories.BOOK_ENCHANTMENTS.name().equals(key)) {
                String[] enchantments;
                EnchantmentStorageMeta enchbookmeta = (EnchantmentStorageMeta)i.getItemMeta();
                for (String enchantmentEntry : enchantments = value.toString().split(";")) {
                    int enchantmentLevel;
                    String[] parts = enchantmentEntry.split(":");
                    if (parts.length != 2) continue;
                    String enchantmentName = parts[0];
                    try {
                        enchantmentLevel = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    Enchantment enchantment = ItemStackSpringer.getEnchantmentByName(enchantmentName);
                    ItemStackSpringer.debugPrint(ItemStackSpringer.class, "Trying to apply " + enchantmentName + " - " + enchantmentLevel);
                    if (enchantment == null) continue;
                    enchbookmeta.addStoredEnchant(enchantment, enchantmentLevel, true);
                }
                i.setItemMeta((ItemMeta)enchbookmeta);
            }
            if (ItemCategories.FIREWORK_DATA.name().equals(key)) {
                FireworkMeta fireworkMeta = (FireworkMeta)i.getItemMeta();
                if (fireworkMeta != null) {
                    Map firework_data = (Map)value;
                    fireworkMeta.setPower(((Integer)firework_data.get("power")).intValue());
                    fireworkMeta.addEffects((Iterable)((List)firework_data.get("effects")).stream().map(ItemStackSpringer::deSerializeFirework).collect(Collectors.toList()));
                }
                i.setItemMeta((ItemMeta)fireworkMeta);
            }
            if (ItemCategories.POTION_DATA.name().equals(key)) {
                PotionMeta potionMeta = (PotionMeta)i.getItemMeta();
                if (potionMeta != null) {
                    potionMeta.setBasePotionData(ItemStackSpringer.deserializePotionData((Map)value));
                }
                i.setItemMeta((ItemMeta)potionMeta);
            }
            if (!ItemCategories.ITEM_ATTRIBUTES.name().equals(key)) continue;
            Map attributesData = (Map)value;
            ArrayListMultimap attributeModifiers = ArrayListMultimap.create();
            for (Map.Entry entry : attributesData.entrySet()) {
                Attribute attribute = Attribute.valueOf((String)((String)entry.getKey()));
                Map modifiersData = (Map)entry.getValue();
                for (Map.Entry modifierEntry : modifiersData.entrySet()) {
                    AttributeModifier modifier = AttributeModifier.deserialize((Map)((Map)modifierEntry.getValue()));
                    attributeModifiers.put((Object)attribute, (Object)modifier);
                }
            }
            meta.setAttributeModifiers((Multimap)attributeModifiers);
            i.setItemMeta(meta);
        }
        ItemStackSpringer.debugPrint(ItemStackSpringer.class, "Item Deserialized: " + String.valueOf(i));
        return i;
    }

    private static void debugPrint(Class<?> c, String s) {
    }

    private static Map<String, Object> serializeFirework(FireworkEffect fireworkEffect) {
        return ImmutableMap.of((Object)"flicker", (Object)fireworkEffect.hasFlicker(), (Object)"trail", (Object)fireworkEffect.hasTrail(), (Object)"colors", ImmutableList.copyOf((Collection)fireworkEffect.getColors()).stream().map(Color::asRGB).collect(Collectors.toList()), (Object)"fade-colors", ImmutableList.copyOf((Collection)fireworkEffect.getFadeColors()).stream().map(Color::asRGB).collect(Collectors.toList()), (Object)"type", (Object)fireworkEffect.getType().name());
    }

    private static FireworkEffect deSerializeFirework(Map<String, Object> stringObjectEntry) {
        return FireworkEffect.builder().trail(((Boolean)stringObjectEntry.get("trail")).booleanValue()).flicker(((Boolean)stringObjectEntry.get("flicker")).booleanValue()).with(FireworkEffect.Type.valueOf((String)((String)stringObjectEntry.get("type")))).withFade((Iterable)((List)stringObjectEntry.get("fade-colors")).stream().map(Color::fromRGB).collect(Collectors.toList())).withColor((Iterable)((List)stringObjectEntry.get("colors")).stream().map(Color::fromRGB).collect(Collectors.toList())).build();
    }

    public static Enchantment getEnchantmentByName(String name) {
        switch (name.toLowerCase()) {
            case "protection": {
                return Enchantment.PROTECTION_ENVIRONMENTAL;
            }
            case "fire_protection": {
                return Enchantment.PROTECTION_FIRE;
            }
            case "feather_falling": {
                return Enchantment.PROTECTION_FALL;
            }
            case "blast_protection": {
                return Enchantment.PROTECTION_EXPLOSIONS;
            }
            case "projectile_protection": {
                return Enchantment.PROTECTION_PROJECTILE;
            }
            case "respiration": {
                return Enchantment.OXYGEN;
            }
            case "aqua_affinity": {
                return Enchantment.WATER_WORKER;
            }
            case "thorns": {
                return Enchantment.THORNS;
            }
            case "depth_strider": {
                return Enchantment.DEPTH_STRIDER;
            }
            case "frost_walker": {
                return Enchantment.FROST_WALKER;
            }
            case "binding_curse": {
                return Enchantment.BINDING_CURSE;
            }
            case "sharpness": {
                return Enchantment.DAMAGE_ALL;
            }
            case "smite": {
                return Enchantment.DAMAGE_UNDEAD;
            }
            case "bane_of_arthropods": {
                return Enchantment.DAMAGE_ARTHROPODS;
            }
            case "knockback": {
                return Enchantment.KNOCKBACK;
            }
            case "fire_aspect": {
                return Enchantment.FIRE_ASPECT;
            }
            case "looting": {
                return Enchantment.LOOT_BONUS_MOBS;
            }
            case "sweeping": {
                return Enchantment.SWEEPING_EDGE;
            }
            case "efficiency": {
                return Enchantment.DIG_SPEED;
            }
            case "silk_touch": {
                return Enchantment.SILK_TOUCH;
            }
            case "unbreaking": {
                return Enchantment.DURABILITY;
            }
            case "fortune": {
                return Enchantment.LOOT_BONUS_BLOCKS;
            }
            case "power": {
                return Enchantment.ARROW_DAMAGE;
            }
            case "punch": {
                return Enchantment.ARROW_KNOCKBACK;
            }
            case "flame": {
                return Enchantment.ARROW_FIRE;
            }
            case "infinity": {
                return Enchantment.ARROW_INFINITE;
            }
            case "luck_of_the_sea": {
                return Enchantment.LUCK;
            }
            case "lure": {
                return Enchantment.LURE;
            }
            case "loyalty": {
                return Enchantment.LOYALTY;
            }
            case "impaling": {
                return Enchantment.IMPALING;
            }
            case "riptide": {
                return Enchantment.RIPTIDE;
            }
            case "channeling": {
                return Enchantment.CHANNELING;
            }
            case "multishot": {
                return Enchantment.MULTISHOT;
            }
            case "quick_charge": {
                return Enchantment.QUICK_CHARGE;
            }
            case "piercing": {
                return Enchantment.PIERCING;
            }
            case "mending": {
                return Enchantment.MENDING;
            }
            case "vanishing_curse": {
                return Enchantment.VANISHING_CURSE;
            }
        }
        RealMinesAPI.getInstance().getPlugin().getLogger().severe(name + " isn't a known Enchantment (is this a bug?) Skipping this enchant.");
        return null;
    }

    public static ItemStack[] getItemsDeSerialized(List<Map<String, Object>> l) {
        Optional<Map> maxSlotItem = l.stream().max(Comparator.comparingInt(map -> map.containsKey("SLOT") ? (Integer)map.get("SLOT") : -1));
        return maxSlotItem.map(maxSLOT -> {
            ItemStack[] arr;
            int slot = (Integer)maxSLOT.get("SLOT");
            if (slot == -1) {
                arr = (ItemStack[])l.stream().map(ItemStackSpringer::getItemDeSerialized).toArray(ItemStack[]::new);
            } else {
                arr = new ItemStack[slot + 1];
                l.forEach(itemStackWrapper1 -> {
                    arr[((Integer)itemStackWrapper1.get((Object)"SLOT")).intValue()] = ItemStackSpringer.getItemDeSerialized(itemStackWrapper1);
                });
            }
            return arr;
        }).orElse(null);
    }

    public static List<Map<String, Object>> getItemsSerialized(ItemStack[] l) {
        return IntStream.range(0, l.length).filter(i -> l[i] != null).mapToObj(item -> ItemStackSpringer.getItemSerialized(l[item])).collect(Collectors.toList());
    }

    public static enum ItemCategories {
        SLOT,
        NAME,
        MATERIAL,
        AMOUNT,
        DAMAGE,
        LORE,
        ENCHANTMENTS,
        EMPTY,
        ITEM_FLAGS,
        ITEM_ATTRIBUTES,
        LEATHER_ARMOR_COLOR,
        BANNER_PATTERNS,
        BOOK_DATA,
        BOOK_ENCHANTMENTS,
        FIREWORK_DATA,
        POTION_DATA;

    }
}

