/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils;

import java.util.List;
import joserodpt.realmines.api.mine.types.farm.FarmItem;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Items {
    public static ItemStack createItem(Material m, int quantidade, String nome) {
        m = Items.checkValidMaterialItem(m);
        ItemStack item = new ItemStack(m, quantidade);
        ItemMeta meta = item.getItemMeta();
        if (nome != null) {
            meta.setDisplayName(Text.color(nome));
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(Material m, int quantidade, String nome, List<String> desc) {
        ItemStack item = new ItemStack(m = Items.checkValidMaterialItem(m), quantidade);
        if (item.getItemMeta() != null) {
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(Text.color(nome));
            meta.setLore(Text.color(desc));
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createItemLoreEnchanted(Material m, int i, String name, List<String> desc) {
        m = Items.checkValidMaterialItem(m);
        ItemStack item = new ItemStack(m, i);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Text.color(name));
        meta.setLore(Text.color(desc));
        meta.addEnchant(Enchantment.LUCK, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    private static Material checkValidMaterialItem(Material m) {
        if (m == Material.WATER) {
            return Material.WATER_BUCKET;
        }
        if (m == Material.LAVA) {
            return Material.LAVA_BUCKET;
        }
        if (!m.isItem()) {
            Material cropIcon = FarmItem.findIconForCrop(m);
            if (cropIcon != null && cropIcon.isItem()) {
                return cropIcon;
            }
            return Material.STONE;
        }
        return m;
    }

    public static ItemStack changeItemStack(String name, List<String> list, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Text.color(name));
        meta.setLore(Text.color(list));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addBreakActionsLore(ItemStack i, List<String> add) {
        List lore;
        ItemMeta meta = i.getItemMeta();
        if (meta != null && (lore = meta.getLore()) != null) {
            lore.add("&6");
            lore.add("&fBreak Actions:");
            lore.addAll(add);
            meta.setLore(Text.color(lore));
            i.setItemMeta(meta);
        }
        return i;
    }
}

