/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PlayerInput
implements Listener {
    private static final Map<UUID, PlayerInput> inputs = new HashMap<UUID, PlayerInput>();
    private final UUID uuid;
    private final List<String> texts = Text.color(RMLanguageConfig.file().getStringList("System.Type-Input"));
    private final InputRunnable runGo;
    private final InputRunnable runCancel;
    private final BukkitTask taskId;
    private boolean clearInput = true;

    public PlayerInput(boolean clearInput, final Player p, InputRunnable correct, InputRunnable cancel) {
        this.uuid = p.getUniqueId();
        p.closeInventory();
        this.runGo = correct;
        this.runCancel = cancel;
        this.clearInput = clearInput;
        this.taskId = new BukkitRunnable(this){
            final /* synthetic */ PlayerInput this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                p.getPlayer().sendTitle(this.this$0.texts.get(0), this.this$0.texts.get(1), 0, 21, 0);
            }
        }.runTaskTimer((Plugin)RealMinesAPI.getInstance().getPlugin(), 0L, 20L);
        this.register();
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST)
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                Player p = event.getPlayer();
                String input = event.getMessage();
                UUID uuid = p.getUniqueId();
                if (inputs.containsKey(uuid)) {
                    event.setCancelled(true);
                    PlayerInput.handlePlayerInput(p, input, uuid);
                }
            }
        };
    }

    private static void handlePlayerInput(Player p, String input, UUID uuid) {
        PlayerInput current = inputs.get(uuid);
        if (current.clearInput) {
            input = ChatColor.stripColor((String)Text.color(input)).trim();
        }
        try {
            current.taskId.cancel();
            p.sendTitle("", "", 0, 1, 0);
            current.unregister();
            String cleanInput = ChatColor.stripColor((String)Text.color(input));
            if (input.equalsIgnoreCase("cancel")) {
                TranslatableLine.SYSTEM_INPUT_CANCELLED.send((CommandSender)p);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RealMinesAPI.getInstance().getPlugin(), () -> current.runCancel.run(cleanInput), 3L);
            } else {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RealMinesAPI.getInstance().getPlugin(), () -> current.runGo.run(cleanInput), 3L);
            }
        }
        catch (Exception e) {
            TranslatableLine.SYSTEM_ERROR_OCCURRED.send((CommandSender)p);
            RealMinesAPI.getInstance().getPlugin().getLogger().warning(e.getMessage());
        }
    }

    private void register() {
        inputs.put(this.uuid, this);
    }

    private void unregister() {
        inputs.remove(this.uuid);
    }

    @FunctionalInterface
    public static interface InputRunnable {
        public void run(String var1);
    }
}

