/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import joserodpt.realmines.api.config.RMConfig;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class Text {
    public static String pluginPrefix = Text.color("&f&lReal&9&lMines");

    public static String color(String string) {
        if (string == null) {
            return "";
        }
        return string.isEmpty() ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void sendList(CommandSender p, List<String> list) {
        list.forEach(s -> p.sendMessage(Text.color(s)));
    }

    public static List<String> color(List<?> list) {
        ArrayList<String> color = new ArrayList<String>();
        list.forEach(o -> color.add(Text.color((String)o)));
        return color;
    }

    public static void send(CommandSender p, String string) {
        p.sendMessage(Text.getPrefix() + Text.color("&f" + string));
    }

    public static String formatNumber(double number) {
        int index;
        String[] suffixes = new String[]{"", "k", "M", "T"};
        for (index = 0; number >= 1000.0 && index < suffixes.length - 1; number /= 1000.0, ++index) {
        }
        return new DecimalFormat("#.#").format(number) + suffixes[index];
    }

    public static String beautifyMaterialName(Material m) {
        if (m == null) {
            return "Unknown";
        }
        String[] parts = m.name().split("_");
        StringBuilder formattedString = new StringBuilder();
        for (String part : parts) {
            if (!part.isEmpty()) {
                formattedString.append(part.substring(0, 1).toUpperCase());
                if (part.length() > 1) {
                    formattedString.append(part.substring(1).toLowerCase());
                }
            }
            formattedString.append(" ");
        }
        return formattedString.toString().trim();
    }

    public static String getProgressBar(int current, int max, int totalBars, char symbol, ChatColor completedColor, ChatColor notCompletedColor) {
        if (max <= 0 || current < 0 || totalBars < 0) {
            return "&d" + symbol;
        }
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        int remainingBars = totalBars - progressBars;
        if (progressBars < 0 || remainingBars < 0) {
            return "&d" + symbol;
        }
        return Strings.repeat((String)(String.valueOf(completedColor) + symbol), (int)progressBars) + Strings.repeat((String)(String.valueOf(notCompletedColor) + symbol), (int)remainingBars);
    }

    public static String location2Command(Location l) {
        return l.getBlockX() + " " + l.getBlockY() + " " + l.getBlockZ();
    }

    public static String getPrefix() {
        return Text.color(RMConfig.file().getString("RealMines.Prefix"));
    }

    public static String formatEpoch(long l) {
        return new SimpleDateFormat("HH:mm:ss dd/MM/yyyy").format(new Date(l));
    }

    public static String formatPercentages(double percentage) {
        return new DecimalFormat("#.##").format(percentage * 100.0);
    }
}

