/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import joserodpt.realmines.api.utils.skulls.internal.TextureApplier;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullCreator {
    private static final Material SKULL_MATERIAL;
    private static final boolean LEGACY_DATA;
    private static final ItemStack EMPTY_SKULL;

    public static ItemStack createSkull() {
        return EMPTY_SKULL.clone();
    }

    @Deprecated
    public static ItemStack itemFromName(String name) {
        return SkullCreator.itemWithName(SkullCreator.createSkull(), name);
    }

    public static ItemStack itemFromUuid(UUID id) {
        return SkullCreator.itemWithUuid(SkullCreator.createSkull(), id);
    }

    public static ItemStack itemFromUrl(String url) {
        return SkullCreator.itemWithUrl(SkullCreator.createSkull(), url);
    }

    public static ItemStack itemFromBase64(String base64) {
        return SkullCreator.itemWithBase64(SkullCreator.createSkull(), base64);
    }

    @Deprecated
    public static ItemStack itemWithName(ItemStack item, String name) {
        Objects.requireNonNull(item, "item");
        Objects.requireNonNull(name, "name");
        UUID id = Bukkit.getOfflinePlayer((String)name).getUniqueId();
        return SkullCreator.itemWithUuid(item, id);
    }

    public static ItemStack itemWithUuid(ItemStack item, UUID id) {
        Objects.requireNonNull(item, "item");
        Objects.requireNonNull(id, "id");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        try {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        }
        catch (NoSuchMethodError ignored) {
            String name = Bukkit.getOfflinePlayer((UUID)id).getName();
            if (name == null) {
                name = id.toString();
            }
            meta.setOwner(name);
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUrl(ItemStack item, String url) {
        Objects.requireNonNull(item, "item");
        Objects.requireNonNull(url, "url");
        return SkullCreator.itemWithBase64(item, SkullCreator.urlToBase64(url));
    }

    public static ItemStack itemWithBase64(ItemStack item, String base64) {
        Objects.requireNonNull(item, "item");
        Objects.requireNonNull(base64, "base64");
        return TextureApplier.item(item, base64);
    }

    @Deprecated
    public static void blockWithName(Block block, String name) {
        Objects.requireNonNull(block, "block");
        Objects.requireNonNull(name, "name");
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        try {
            state.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        }
        catch (NoSuchMethodError ignored) {
            state.setOwner(name);
        }
        state.update(false, false);
    }

    public static void blockWithUuid(Block block, UUID id) {
        Objects.requireNonNull(block, "block");
        Objects.requireNonNull(id, "id");
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        try {
            state.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        }
        catch (NoSuchMethodError ignored) {
            String name = Bukkit.getOfflinePlayer((UUID)id).getName();
            if (name == null) {
                name = id.toString();
            }
            state.setOwner(name);
        }
        state.update(false, false);
    }

    public static void blockWithUrl(Block block, String url) {
        Objects.requireNonNull(block, "block");
        Objects.requireNonNull(url, "url");
        SkullCreator.blockWithBase64(block, SkullCreator.urlToBase64(url));
    }

    public static void blockWithBase64(Block block, String base64) {
        Objects.requireNonNull(block, "block");
        Objects.requireNonNull(base64, "base64");
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        TextureApplier.block(state, base64);
        state.update(true, false);
    }

    private static void setToSkull(Block block) {
        Material blockMat = Material.matchMaterial((String)"PLAYER_HEAD");
        if (blockMat == null) {
            blockMat = Material.matchMaterial((String)"SKULL");
        }
        block.setType(blockMat, false);
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String json = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl.toString() + "\"}}}";
        return Base64.getEncoder().encodeToString(json.getBytes());
    }

    public static void clearCache() {
        TextureApplier.clearCache();
    }

    public static int getCacheSize() {
        return TextureApplier.getCacheSize();
    }

    public static boolean isReflectionInitialized() {
        return TextureApplier.ready();
    }

    static {
        Material tmp = Material.matchMaterial((String)"PLAYER_HEAD");
        if (tmp == null) {
            tmp = Material.matchMaterial((String)"SKULL_ITEM");
        }
        EMPTY_SKULL = (LEGACY_DATA = "SKULL_ITEM".equals((SKULL_MATERIAL = tmp).name())) ? new ItemStack(SKULL_MATERIAL, 1, 3) : new ItemStack(SKULL_MATERIAL);
    }
}

