/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.VersionPatch;

public final class PatchesRegistry {
    private static final List<VersionPatch> PATCHES = new ArrayList<VersionPatch>();

    private PatchesRegistry() {
    }

    public static void register(VersionPatch patch) {
        PATCHES.add(patch);
    }

    public static List<VersionPatch> patches() {
        return Collections.unmodifiableList(PATCHES);
    }

    public static VersionPatch select(String mcVersion) {
        for (VersionPatch patch : PATCHES) {
            try {
                if (!patch.supports(mcVersion)) continue;
                return patch;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }
}

