/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal;

import joserodpt.realmines.api.utils.skulls.internal.bootstrap.PatchBootstrap;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.VersionPatch;
import org.bukkit.Bukkit;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;

public final class TextureApplier {
    private static VersionPatch PATCH;
    private static volatile boolean warned;

    private TextureApplier() {
    }

    public static ItemStack item(ItemStack item, String base64) {
        if (PATCH == null) {
            TextureApplier.logOnce();
            return item;
        }
        return PATCH.applyToItem(item, base64);
    }

    public static void block(Skull skull, String base64) {
        if (PATCH == null) {
            TextureApplier.logOnce();
            return;
        }
        PATCH.applyToBlock(skull, base64);
    }

    private static void logOnce() {
        if (!warned) {
            Bukkit.getLogger().warning("[SkullCreator] No compatible VersionPatch for this server; heads will stay vanilla.");
            warned = true;
        }
    }

    public static boolean ready() {
        return PATCH != null;
    }

    public static void clearCache() {
        if (PATCH != null) {
            PATCH.clearCache();
        }
    }

    public static int getCacheSize() {
        return PATCH != null ? PATCH.getCacheSize() : 0;
    }

    static {
        PatchBootstrap.bootstrap();
        PATCH = PatchBootstrap.active();
    }
}

