/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.bootstrap;

import joserodpt.realmines.api.utils.skulls.internal.PatchesRegistry;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.VersionPatch;
import org.bukkit.Bukkit;

public final class PatchBootstrap {
    private static volatile VersionPatch ACTIVE;

    private PatchBootstrap() {
    }

    public static boolean bootstrap() {
        VersionPatch patch;
        String version = Bukkit.getBukkitVersion();
        try {
            String[] patchClasses = new String[]{"joserodpt.realmines.api.utils.skulls.internal.patches.v1219", "joserodpt.realmines.api.utils.skulls.internal.patches.v121x_1218", "joserodpt.realmines.api.utils.skulls.internal.patches.v18x_120x"};
            ClassLoader cl = PatchBootstrap.class.getClassLoader();
            for (String cn : patchClasses) {
                try {
                    Class.forName(cn, true, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable patchClasses) {
            // empty catch block
        }
        if ((patch = PatchesRegistry.select(version)) != null) {
            ACTIVE = patch;
            Bukkit.getLogger().info("[SkullCreator] Selected patch " + patch.getClass().getSimpleName());
            return true;
        }
        Bukkit.getLogger().warning("[SkullCreator] No patch available for " + version);
        return false;
    }

    public static VersionPatch active() {
        return ACTIVE;
    }
}

