/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.interfaces;

import joserodpt.realmines.api.utils.skulls.internal.interfaces.SupportedVersion;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;

public interface VersionPatch {
    default public boolean supports(String version) {
        SupportedVersion ann = this.getClass().getAnnotation(SupportedVersion.class);
        if (ann == null) {
            return false;
        }
        for (String prefix : ann.value()) {
            if (prefix.endsWith("+")) {
                String minVersion = prefix.substring(0, prefix.length() - 1);
                if (this.compareVersions(version, minVersion) < 0) continue;
                return true;
            }
            if (!version.startsWith(prefix)) continue;
            int nextIdx = prefix.length();
            if (nextIdx >= version.length()) {
                return true;
            }
            char nextChar = version.charAt(nextIdx);
            if (nextChar == '.' || Character.isDigit(nextChar)) continue;
            return true;
        }
        return false;
    }

    default public int compareVersions(String version1, String version2) {
        String v1 = this.extractNumericVersion(version1);
        String v2 = this.extractNumericVersion(version2);
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < parts1.length ? this.parseVersionPart(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? this.parseVersionPart(parts2[i]) : 0;
            if (num1 == num2) continue;
            return num1 - num2;
        }
        return 0;
    }

    default public String extractNumericVersion(String version) {
        int endIndex = version.length();
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c != '-' && c != '_') continue;
            endIndex = i;
            break;
        }
        return version.substring(0, endIndex);
    }

    default public int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public ItemStack applyToItem(ItemStack var1, String var2);

    public void applyToBlock(Skull var1, String var2);

    default public void clearCache() {
    }

    default public int getCacheSize() {
        return 0;
    }
}

