/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.patches;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import joserodpt.realmines.api.utils.skulls.internal.PatchesRegistry;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.SupportedVersion;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.VersionPatch;
import joserodpt.realmines.api.utils.skulls.internal.util.Utilities;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

@SupportedVersion(value={"1.21.9+"})
public final class v1219
implements VersionPatch {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();

    @Override
    public ItemStack applyToItem(ItemStack item, String base64) {
        if (!(item.getItemMeta() instanceof SkullMeta) || base64 == null) {
            return item;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        Object playerProfile = this.getCachedPlayerProfile(base64);
        if (playerProfile == null) {
            return item;
        }
        try {
            Class<?> skullMetaInterface = Class.forName("org.bukkit.inventory.meta.SkullMeta");
            Class<?> playerProfileInterface = Class.forName("org.bukkit.profile.PlayerProfile");
            Method setOwnerProfileMethod = skullMetaInterface.getMethod("setOwnerProfile", playerProfileInterface);
            setOwnerProfileMethod.setAccessible(true);
            setOwnerProfileMethod.invoke((Object)meta, playerProfile);
            item.setItemMeta((ItemMeta)meta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    private Object getCachedPlayerProfile(String base64) {
        return this.cache.computeIfAbsent(base64, Utilities::createPlayerProfile);
    }

    @Override
    public void applyToBlock(Skull skull, String base64) {
        if (skull == null || base64 == null) {
            return;
        }
        Object playerProfile = this.getCachedPlayerProfile(base64);
        if (playerProfile == null) {
            return;
        }
        try {
            Class<?> skullInterface = Class.forName("org.bukkit.block.Skull");
            Class<?> playerProfileInterface = Class.forName("org.bukkit.profile.PlayerProfile");
            Method setOwnerProfileMethod = skullInterface.getMethod("setOwnerProfile", playerProfileInterface);
            setOwnerProfileMethod.setAccessible(true);
            setOwnerProfileMethod.invoke((Object)skull, playerProfile);
            skull.update(true, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    static {
        PatchesRegistry.register(new v1219());
    }
}

