/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.patches;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import joserodpt.realmines.api.utils.skulls.internal.PatchesRegistry;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.SupportedVersion;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.VersionPatch;
import joserodpt.realmines.api.utils.skulls.internal.util.Utilities;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

@SupportedVersion(value={"1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8"})
public final class v121x_1218
implements VersionPatch {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
    private static final Field SKULL_PROFILE_FIELD;
    private static volatile Field BLOCK_PROFILE_FIELD;

    @Override
    public ItemStack applyToItem(ItemStack item, String base64) {
        if (!(item.getItemMeta() instanceof SkullMeta) || base64 == null) {
            return item;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (SKULL_PROFILE_FIELD == null) {
            return item;
        }
        Object gp = this.getCachedGameProfile(base64);
        if (gp == null) {
            return item;
        }
        Object profileObj = gp;
        Class<?> fieldType = SKULL_PROFILE_FIELD.getType();
        if (!fieldType.isAssignableFrom(gp.getClass())) {
            try {
                for (Constructor<?> c : fieldType.getDeclaredConstructors()) {
                    Class<?>[] pt = c.getParameterTypes();
                    if (pt.length < 1 || !pt[0].isAssignableFrom(gp.getClass())) continue;
                    Object[] args = new Object[pt.length];
                    args[0] = gp;
                    for (int i = 1; i < pt.length; ++i) {
                        args[i] = pt[i] == Boolean.TYPE || pt[i] == Boolean.class ? Boolean.FALSE : null;
                    }
                    c.setAccessible(true);
                    profileObj = c.newInstance(args);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            SKULL_PROFILE_FIELD.set(meta, profileObj);
            item.setItemMeta((ItemMeta)meta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    private Object getCachedGameProfile(String base64) {
        return this.cache.computeIfAbsent(base64, Utilities::createGameProfile);
    }

    @Override
    public void applyToBlock(Skull skull, String base64) {
        if (base64 == null || skull == null) {
            return;
        }
        Field pf = BLOCK_PROFILE_FIELD;
        if (pf == null) {
            for (Field f : skull.getClass().getDeclaredFields()) {
                String name = f.getName().toLowerCase();
                if (!name.contains("profile") && !name.contains("gameprofile")) continue;
                f.setAccessible(true);
                pf = f;
                break;
            }
            BLOCK_PROFILE_FIELD = pf;
        }
        if (pf == null) {
            return;
        }
        Object gp = this.getCachedGameProfile(base64);
        if (gp == null) {
            return;
        }
        Object profileObj = gp;
        Class<?> fieldType = pf.getType();
        if (!fieldType.isAssignableFrom(gp.getClass())) {
            try {
                for (Constructor<?> c : fieldType.getDeclaredConstructors()) {
                    Class<?>[] pt = c.getParameterTypes();
                    if (pt.length < 1 || !pt[0].isAssignableFrom(gp.getClass())) continue;
                    Object[] args = new Object[pt.length];
                    args[0] = gp;
                    for (int i = 1; i < pt.length; ++i) {
                        args[i] = pt[i] == Boolean.TYPE || pt[i] == Boolean.class ? Boolean.FALSE : null;
                    }
                    c.setAccessible(true);
                    profileObj = c.newInstance(args);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            pf.set(skull, profileObj);
            skull.update(true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    static {
        PatchesRegistry.register(new v121x_1218());
        Field pf = null;
        try {
            Class<?> cms;
            String version = Utilities.getObcVersion();
            try {
                cms = Class.forName("org.bukkit.craftbukkit." + version + ".inventory.CraftMetaSkull");
            }
            catch (ClassNotFoundException e) {
                cms = Class.forName("org.bukkit.craftbukkit.inventory.CraftMetaSkull");
            }
            pf = cms.getDeclaredField("profile");
            pf.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SKULL_PROFILE_FIELD = pf;
    }
}

