/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.patches;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import joserodpt.realmines.api.utils.skulls.internal.PatchesRegistry;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.SupportedVersion;
import joserodpt.realmines.api.utils.skulls.internal.interfaces.VersionPatch;
import joserodpt.realmines.api.utils.skulls.internal.util.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

@SupportedVersion(value={"1.8.", "1.9.", "1.10.", "1.11.", "1.12.", "1.13.", "1.14.", "1.15.", "1.16.", "1.17.", "1.18.", "1.19.", "1.20."})
public final class v18x_120x
implements VersionPatch {
    private final Field profileField;
    private final Constructor<?> gameProfileCtor;
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();

    public v18x_120x() {
        Field pf = null;
        Constructor<?> gpc = null;
        Field prf = null;
        try {
            Class<?> craftMetaSkullCls;
            Class<?> gameProfileCls = Class.forName("com.mojang.authlib.GameProfile");
            gpc = gameProfileCls.getConstructor(UUID.class, String.class);
            prf = gameProfileCls.getDeclaredField("properties");
            prf.setAccessible(true);
            String version = Utilities.getObcVersion();
            try {
                craftMetaSkullCls = Class.forName("org.bukkit.craftbukkit." + version + ".inventory.CraftMetaSkull");
            }
            catch (ClassNotFoundException e) {
                craftMetaSkullCls = Class.forName("org.bukkit.craftbukkit.inventory.CraftMetaSkull");
            }
            pf = craftMetaSkullCls.getDeclaredField("profile");
            pf.setAccessible(true);
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("SkullCreator: Patch180_1132 reflection init failed \u2192 " + String.valueOf(ex));
        }
        this.profileField = pf;
        this.gameProfileCtor = gpc;
    }

    @Override
    public ItemStack applyToItem(ItemStack item, String base64) {
        if (!(item.getItemMeta() instanceof SkullMeta)) {
            return item;
        }
        if (this.profileField == null || this.gameProfileCtor == null) {
            return item;
        }
        try {
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            Object gameProfile = this.getCachedGameProfile(base64);
            if (gameProfile == null) {
                return item;
            }
            this.profileField.set(meta, gameProfile);
            item.setItemMeta((ItemMeta)meta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    @Override
    public void applyToBlock(Skull skull, String base64) {
        if (this.gameProfileCtor == null) {
            return;
        }
        try {
            Object gameProfile = this.getCachedGameProfile(base64);
            if (gameProfile == null) {
                return;
            }
            try {
                Class<?> skullTypeCls = Class.forName("org.bukkit.SkullType");
                Object playerType = Enum.valueOf(skullTypeCls, "PLAYER");
                Method setType = skull.getClass().getMethod("setSkullType", skullTypeCls);
                setType.invoke((Object)skull, playerType);
            }
            catch (Exception skullTypeCls) {
                // empty catch block
            }
            try {
                Class<?> gpClass = gameProfile.getClass();
                Field fProfile = null;
                for (Field f : skull.getClass().getDeclaredFields()) {
                    if (!gpClass.isAssignableFrom(f.getType())) continue;
                    fProfile = f;
                    break;
                }
                if (fProfile != null) {
                    fProfile.setAccessible(true);
                    fProfile.set(skull, gameProfile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                skull.update(true, true);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    private Object getCachedGameProfile(String base64) {
        return this.cache.computeIfAbsent(base64, this::createGameProfile);
    }

    private Object createGameProfile(String base64) {
        return Utilities.createGameProfile(base64);
    }

    static {
        PatchesRegistry.register(new v18x_120x());
    }
}

