/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public final class TexturePropertyWriter {
    private static final Logger LOGGER = Logger.getLogger(TexturePropertyWriter.class.getName());

    private TexturePropertyWriter() {
    }

    public static void injectTexture(Object profileObj, String base64) {
        block18: {
            if (profileObj == null || base64 == null) {
                return;
            }
            try {
                Method setSkin;
                URL url;
                Method getTex = profileObj.getClass().getMethod("getTextures", new Class[0]);
                Object textures = getTex.invoke(profileObj, new Object[0]);
                if (textures == null || (url = TexturePropertyWriter.extractUrl(base64)) == null) break block18;
                try {
                    setSkin = textures.getClass().getMethod("setSkin", URL.class);
                }
                catch (NoSuchMethodException nf) {
                    setSkin = textures.getClass().getMethod("setSkin", URL.class, Class.forName("org.bukkit.profile.PlayerTextures$SkinModel"));
                }
                setSkin.invoke(textures, url);
                Class<?> ptIface = Class.forName("org.bukkit.profile.PlayerTextures");
                Method setTextures = profileObj.getClass().getMethod("setTextures", ptIface);
                setTextures.invoke(profileObj, textures);
                return;
            }
            catch (Exception getTex) {
                // empty catch block
            }
        }
        for (Method m : profileObj.getClass().getMethods()) {
            Class<?>[] pt;
            if (!m.getName().equals("setProperty") || (pt = m.getParameterTypes()).length != 2 || pt[0] != String.class || pt[1] != String.class) continue;
            try {
                m.invoke(profileObj, "textures", base64);
                return;
            }
            catch (Exception setTextures) {
                // empty catch block
            }
        }
        try {
            Object propObj;
            Object props = null;
            try {
                Method getProps = profileObj.getClass().getMethod("getProperties", new Class[0]);
                props = getProps.invoke(profileObj, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field propsField = profileObj.getClass().getDeclaredField("properties");
                propsField.setAccessible(true);
                props = propsField.get(profileObj);
            }
            Class<?> propClass = Class.forName("com.mojang.authlib.properties.Property");
            try {
                Constructor<?> propCtor = propClass.getConstructor(String.class, String.class);
                propObj = propCtor.newInstance("textures", base64);
            }
            catch (NoSuchMethodException nf) {
                Constructor<?> propCtor = propClass.getConstructor(String.class, String.class, String.class);
                propObj = propCtor.newInstance("textures", base64, "");
            }
            try {
                Method put = props.getClass().getMethod("put", String.class, propClass);
                put.invoke(props, "textures", propObj);
            }
            catch (Exception e) {
                try {
                    Method put = props.getClass().getMethod("put", Object.class, Object.class);
                    put.invoke(props, "textures", propObj);
                }
                catch (Exception e2) {
                    Method putAll = props.getClass().getMethod("putAll", String.class, Iterable.class);
                    List<?> list = Collections.singletonList(propObj);
                    putAll.invoke(props, "textures", list);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static URL extractUrl(String b64) {
        try {
            String json = new String(Base64.getDecoder().decode(b64));
            int idx = json.indexOf("\"url\":\"");
            if (idx == -1) {
                return null;
            }
            int start = idx + 7;
            int end = json.indexOf(34, start);
            if (end == -1) {
                return null;
            }
            String urlStr = json.substring(start, end).replace("\\/", "/");
            return new URL(urlStr);
        }
        catch (Exception e) {
            return null;
        }
    }
}

