/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.utils.skulls.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import joserodpt.realmines.api.utils.skulls.internal.util.TexturePropertyWriter;
import org.bukkit.Bukkit;

public final class Utilities {
    private Utilities() {
    }

    public static UUID deterministicUUID(String base64) {
        long hash = base64.hashCode();
        return new UUID(hash, hash);
    }

    public static String getObcVersion() {
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String[] parts = pkg.split("\\.");
        return parts.length > 3 ? parts[3] : "";
    }

    public static Object createGameProfile(String base64) {
        if (base64 == null) {
            return null;
        }
        try {
            ReflectionCache c = ReflectionCache.INSTANCE.get();
            UUID uuid = Utilities.deterministicUUID(base64);
            Object profile = c.gameProfileCtor.newInstance(uuid, "");
            TexturePropertyWriter.injectTexture(profile, base64);
            return profile;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object createPlayerProfile(String base64) {
        if (base64 == null) {
            return null;
        }
        try {
            UUID uuid = Utilities.deterministicUUID(base64);
            Method createProfileMethod = Bukkit.class.getMethod("createPlayerProfile", UUID.class, String.class);
            Object playerProfile = createProfileMethod.invoke(null, uuid, "");
            TexturePropertyWriter.injectTexture(playerProfile, base64);
            return playerProfile;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static final class ReflectionCache {
        private static final AtomicReference<ReflectionCache> INSTANCE = new AtomicReference();
        private final Constructor<?> gameProfileCtor;

        private ReflectionCache() {
            Constructor<?> gpc = null;
            try {
                Class<?> gameProfileCls = Class.forName("com.mojang.authlib.GameProfile");
                gpc = gameProfileCls.getConstructor(UUID.class, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gameProfileCtor = gpc;
        }

        static {
            INSTANCE.set(new ReflectionCache());
        }
    }
}

