/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin;

import java.util.logging.Logger;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.plugin.RealMinesPlugin;
import joserodpt.realmines.plugin.gui.GUIManager;
import joserodpt.realmines.plugin.managers.MineManager;
import joserodpt.realmines.plugin.managers.MineResetTasksManager;
import net.milkbowl.vault.economy.Economy;

public class RealMines
extends RealMinesAPI {
    private final Logger logger;
    private final RealMinesPlugin plugin;
    private final MineManager mineManager;
    private final MineResetTasksManager mineResetTasksManager;
    private final GUIManager guiManager;

    public RealMines(RealMinesPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.mineManager = new MineManager(this);
        this.mineResetTasksManager = new MineResetTasksManager(this);
        this.guiManager = new GUIManager(this);
    }

    @Override
    public RealMinesPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public GUIManager getGUIManager() {
        return this.guiManager;
    }

    @Override
    public MineManager getMineManager() {
        return this.mineManager;
    }

    @Override
    public MineResetTasksManager getMineResetTasksManager() {
        return this.mineResetTasksManager;
    }

    @Override
    public boolean hasNewUpdate() {
        return this.plugin.newUpdate;
    }

    @Override
    public void reload() {
        RMConfig.reload();
        RMLanguageConfig.reload();
        this.mineManager.unloadMines();
        this.mineManager.loadMines();
        this.logger.info("[RealMines] Loaded " + this.mineManager.getMines().size() + " mines and " + this.mineManager.getSigns().size() + " mine signs.");
    }

    @Override
    public Economy getEconomy() {
        return this.plugin.getEconomy();
    }

    @Override
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

