/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin;

import dev.triumphteam.cmd.bukkit.BukkitCommandManager;
import dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import dev.triumphteam.cmd.core.BaseCommand;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.RMMinesOldConfig;
import joserodpt.realmines.api.config.RPMineResetTasksConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.converters.RMSupportedConverters;
import joserodpt.realmines.api.event.RealMinesPluginLoadedEvent;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.utils.GUIBuilder;
import joserodpt.realmines.api.utils.PercentageInput;
import joserodpt.realmines.api.utils.PlayerInput;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.plugin.Metrics;
import joserodpt.realmines.plugin.RealMines;
import joserodpt.realmines.plugin.RealMinesPlaceholderAPI;
import joserodpt.realmines.plugin.UpdateChecker;
import joserodpt.realmines.plugin.command.BaseCommandWA;
import joserodpt.realmines.plugin.command.MineCMD;
import joserodpt.realmines.plugin.command.MineResetTaskCMD;
import joserodpt.realmines.plugin.events.BlockEvents;
import joserodpt.realmines.plugin.events.PlayerEvents;
import joserodpt.realmines.plugin.gui.DirectoryBrowserGUI;
import joserodpt.realmines.plugin.gui.MaterialPickerGUI;
import joserodpt.realmines.plugin.gui.MineBreakActionsGUI;
import joserodpt.realmines.plugin.gui.MineColorPickerGUI;
import joserodpt.realmines.plugin.gui.MineFacesGUI;
import joserodpt.realmines.plugin.gui.MineItemsGUI;
import joserodpt.realmines.plugin.gui.MineListGUI;
import joserodpt.realmines.plugin.gui.MineResetGUI;
import joserodpt.realmines.plugin.gui.RealMinesGUI;
import joserodpt.realmines.plugin.gui.SettingsGUI;
import joserodpt.realpermissions.api.RealPermissionsAPI;
import joserodpt.realpermissions.api.pluginhook.ExternalPlugin;
import joserodpt.realpermissions.api.pluginhook.ExternalPluginPermission;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RealMinesPlugin
extends JavaPlugin {
    static RealMinesPlugin instance;
    private static RealMines realMines;
    public Boolean newUpdate = false;
    private PluginManager pm = Bukkit.getPluginManager();
    private BukkitTask mineHighlight;
    private Economy econ;

    public void onEnable() {
        RegisteredServiceProvider rsp;
        File folder2;
        this.printASCII();
        long start = System.currentTimeMillis();
        instance = this;
        RMConfig.setup(this);
        realMines = new RealMines(this);
        RealMinesAPI.setInstance(realMines);
        new Metrics(this, 10574);
        this.saveDefaultConfig();
        RMConfig.setup(this);
        RPMineResetTasksConfig.setup(this);
        RMLanguageConfig.setup(this);
        File folder = new File(this.getDataFolder(), "schematics");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(folder2 = new File(this.getDataFolder(), "mines")).exists()) {
            folder2.mkdir();
        }
        RMMinesOldConfig.setup(this);
        Arrays.asList(new PlayerEvents(realMines), new BlockEvents(realMines), MineListGUI.getListener(), GUIBuilder.getListener(), MineFacesGUI.getListener(), MaterialPickerGUI.getListener(), MineItemsGUI.getListener(), MineResetGUI.getListener(), MineColorPickerGUI.getListener(), MineBreakActionsGUI.getListener(), RealMinesGUI.getListener(), SettingsGUI.getListener(), PercentageInput.getListener(), DirectoryBrowserGUI.getListener(), PlayerInput.getListener()).forEach(listener -> this.pm.registerEvents(listener, (Plugin)this));
        if (this.getServer().getPluginManager().getPlugin("Vault") != null && (rsp = this.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.econ = (Economy)rsp.getProvider();
            if (this.econ != null) {
                this.getLogger().info("Hooked into Vault!");
            }
        }
        BukkitCommandManager<CommandSender> commandManager = BukkitCommandManager.create((Plugin)this);
        commandManager.registerSuggestion(SuggestionKey.of("#createsuggestions"), (sender, context) -> IntStream.range(0, 100).mapToObj(i -> "Mine" + i).collect(Collectors.toList()));
        commandManager.registerSuggestion(SuggestionKey.of("#minetasksuggestions"), (sender, context) -> IntStream.range(0, 50).mapToObj(i -> "MineResetTask" + i).collect(Collectors.toList()));
        commandManager.registerSuggestion(SuggestionKey.of("#types"), (sender, context) -> Arrays.asList("b", "s", "f", "blocks", "farm", "schem", "schematic"));
        commandManager.registerSuggestion(SuggestionKey.of("#converters"), (sender, context) -> Arrays.stream(RMSupportedConverters.values()).map(RMSupportedConverters::getSourceName).collect(Collectors.toList()));
        commandManager.registerSuggestion(SuggestionKey.of("#mines"), (sender, context) -> realMines.getMineManager().getRegisteredMines());
        commandManager.registerSuggestion(SuggestionKey.of("#minetasks"), (sender, context) -> realMines.getMineResetTasksManager().getRegisteredTasks());
        commandManager.registerSuggestion(SuggestionKey.of("#minecountdowns"), (sender, context) -> {
            RMine mine = realMines.getMineManager().getMine(context.getArgs().get(0));
            if (mine != null && mine.getMineTimer() != null && mine.getMineTimer().getCountdown() != null) {
                Integer countdown = mine.getCountdown();
                if (countdown == null) {
                    return List.of();
                }
                return List.of(countdown.toString());
            }
            return List.of();
        });
        HashMap<String, BaseCommandWA> commands = new HashMap<String, BaseCommandWA>();
        this.registerCommand("realmines", new MineCMD(realMines), commands, commandManager);
        this.registerCommand("realminesresettask", new MineResetTaskCMD(realMines), commands, commandManager);
        commandManager.registerMessage(MessageKey.UNKNOWN_COMMAND, (sender, context) -> TranslatableLine.SYSTEM_ERROR_COMMAND.send((CommandSender)sender));
        commandManager.registerMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, (sender, context) -> Text.send(sender, ((BaseCommandWA)commands.get(context.getCommand())).getWrongUsage(context.getSubCommand())));
        commandManager.registerMessage(BukkitMessageKey.NO_PERMISSION, (sender, context) -> TranslatableLine.SYSTEM_ERROR_PERMISSION.send((CommandSender)sender));
        this.getLogger().info("Loading Mines.");
        realMines.getMineManager().loadMines();
        realMines.getMineResetTasksManager().loadTasks();
        this.getLogger().info("Loaded " + realMines.getMineManager().getMines().size() + " mines and " + realMines.getMineManager().getSigns().size() + " mine signs.");
        this.getLogger().info("Loaded " + realMines.getMineResetTasksManager().getTasks().size() + " mine tasks.");
        this.mineHighlight = new BukkitRunnable(){

            public void run() {
                realMines.getMineManager().getMines().values().forEach(RMine::highlight);
            }
        }.runTaskTimerAsynchronously((Plugin)this, 0L, 10L);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new RealMinesPlaceholderAPI(realMines).register();
            this.getLogger().info("Hooked onto PlaceholderAPI!");
        }
        Bukkit.getPluginManager().callEvent((Event)new RealMinesPluginLoadedEvent());
        if (RMConfig.file().getBoolean("RealMines.useWorldEditForBlockPlacement").booleanValue()) {
            this.getLogger().info("Using FAWE/WorldEdit for block placement.");
        }
        if (this.getServer().getPluginManager().getPlugin("RealPermissions") != null) {
            try {
                RealPermissionsAPI.getInstance().getHooksAPI().addHook(new ExternalPlugin(this.getDescription().getName(), "&fReal&9Mines", this.getDescription().getDescription(), Material.DIAMOND_PICKAXE, Arrays.asList(new ExternalPluginPermission("realmines.admin", "Allow access to the main operator commands of RealMines.", Arrays.asList("rm reload", "rm mines", "rm panel", "rm stoptasks", "rm starttasks", "rm list", "rm create", "rm settp", "rm tp", "rm clear", "rm reset")), new ExternalPluginPermission("realmines.tp.<name>", "Allow permission to teleport to a mine.", Collections.singletonList("rm tp <name>")), new ExternalPluginPermission("realmines.silent", "Allow permission to silence a mine.", Arrays.asList("rm silent", "rm silentall")), new ExternalPluginPermission("realmines.reset", "Allow permission to reset all mines."), new ExternalPluginPermission("realmines.update.notify", "Notification of a plugin update to the player.")), this.getDescription().getVersion()));
            }
            catch (Exception e) {
                this.getLogger().warning("Error while trying to register RealMines permissions onto RealPermissions.");
                e.printStackTrace();
            }
        }
        this.getLogger().info("Finished loading in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds.");
        this.getLogger().info("<------------------ RealMines vPT ------------------>".replace("PT", this.getDescription().getVersion()));
        new UpdateChecker(this, 73707).getVersion(version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                this.getLogger().info("The plugin is updated to the latest version.");
            } else {
                this.newUpdate = true;
                this.getLogger().warning("There is a new update available! Version: " + version + " https://www.spigotmc.org/resources/73707/");
            }
        });
    }

    private void registerCommand(String realmines, BaseCommandWA mineCMD, Map<String, BaseCommandWA> commands, BukkitCommandManager<CommandSender> commandManager) {
        commands.put(realmines, mineCMD);
        commandManager.registerCommand((BaseCommand)mineCMD);
    }

    private void printASCII() {
        this.logWithColor("&9   _____           ____  ____");
        this.logWithColor("&9  | ___ \\         | |  \\/  (_)  &8Version: &9" + this.getDescription().getVersion());
        this.logWithColor("&9  | |_/ /___  __ _| | .  . |_ _ __   ___  ___");
        this.logWithColor("&9  |    // _ \\/ _` | | |\\/| | | '_ \\ / _ \\/ __|");
        this.logWithColor("&9  | |\\ \\  __/ (_| | | |  | | | | | |  __/\\__ \\");
        this.logWithColor("&9  \\_| \\_\\___|\\__,_|_\\_|  |_/_|_| |_|\\___||___/");
        this.logWithColor("&9                         &8Made by: &9JoseGamer_PT");
    }

    public void logWithColor(String s) {
        this.getServer().getConsoleSender().sendMessage("[" + this.getDescription().getName() + "] " + Text.color(s));
    }

    public void onDisable() {
        if (this.mineHighlight != null) {
            this.mineHighlight.cancel();
        }
        realMines.getMineManager().clearMemory();
    }

    public static RealMinesPlugin getPlugin() {
        return instance;
    }

    public Economy getEconomy() {
        return this.econ;
    }
}

