/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.command;

import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotation.Command;
import dev.triumphteam.cmd.core.annotation.Default;
import dev.triumphteam.cmd.core.annotation.SubCommand;
import dev.triumphteam.cmd.core.annotation.Suggestion;
import java.util.Arrays;
import java.util.Objects;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.converters.RMSupportedConverters;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.plugin.RealMines;
import joserodpt.realmines.plugin.command.BaseCommandWA;
import joserodpt.realmines.plugin.command.WrongUsage;
import joserodpt.realmines.plugin.gui.MineItemsGUI;
import joserodpt.realmines.plugin.gui.MineListGUI;
import joserodpt.realmines.plugin.gui.RealMinesGUI;
import joserodpt.realmines.plugin.gui.SettingsGUI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(value="realmines", alias={"mine", "rm"})
public class MineCMD
extends BaseCommandWA {
    private final RealMines rm;

    public MineCMD(RealMines rm) {
        this.rm = rm;
    }

    @Default
    public void defaultCommand(CommandSender commandSender) {
        Player p;
        Text.sendList(commandSender, Arrays.asList("         &fReal&9Mines", "         &7Release &a" + this.rm.getPlugin().getDescription().getVersion()));
        if (commandSender instanceof Player && ((p = (Player)commandSender).hasPermission("realmines.admin") || p.isOp())) {
            RealMinesGUI rmg = new RealMinesGUI(p, this.rm);
            rmg.openInventory(p);
        }
    }

    @SubCommand(value="reload", alias={"rl"})
    @Permission(value={"realmines.admin"})
    public void reload(CommandSender commandSender) {
        this.rm.reload();
        TranslatableLine.SYSTEM_RELOADED.send(commandSender);
    }

    @SubCommand(value="mines", alias={"p", "panel"})
    @Permission(value={"realmines.admin"})
    public void minescmd(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            MineListGUI v = new MineListGUI(this.rm, p, MineListGUI.MineListSort.DEFAULT);
            v.openInventory(p);
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="stoptasks")
    @Permission(value={"realmines.admin"})
    public void stoptaskscmd(CommandSender commandSender) {
        this.rm.getMineManager().stopTasks();
        TranslatableLine.SYSTEM_STOPPED_MINE_TASKS.send(commandSender);
    }

    @SubCommand(value="starttasks")
    @Permission(value={"realmines.admin"})
    public void starttaskcmd(CommandSender commandSender) {
        this.rm.getMineManager().startTasks();
        TranslatableLine.SYSTEM_STARTED_MINE_TASKS.send(commandSender);
    }

    @SubCommand(value="list", alias={"l"})
    @Permission(value={"realmines.admin"})
    public void listcmd(CommandSender commandSender) {
        this.rm.getMineManager().getMines().values().forEach(mine -> Text.send(commandSender, "&f" + mine.getName() + " &r&7(&f" + mine.getDisplayName() + "&r&7)"));
    }

    @SubCommand(value="create")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine create <name> <type>")
    public void createcmd(CommandSender commandSender, @Suggestion(value="#createsuggestions") String name, @Suggestion(value="#types") String type) {
        if (name == null || name.isEmpty()) {
            Text.send(commandSender, "&cInvalid mine name.");
            return;
        }
        if (type == null || type.isEmpty()) {
            Text.send(commandSender, "&cInvalid mine type.");
            return;
        }
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            RMine m = this.rm.getMineManager().getMine(name);
            if (m == null) {
                switch (type) {
                    case "b": 
                    case "blocks": {
                        this.rm.getMineManager().createMine(p, name);
                        break;
                    }
                    case "f": 
                    case "farm": {
                        this.rm.getMineManager().createFarmMine(p, name);
                        break;
                    }
                    case "s": 
                    case "schem": 
                    case "schematic": {
                        this.rm.getMineManager().createSchematicMine(p, name);
                        break;
                    }
                    default: {
                        Text.send((CommandSender)p, "&cInvalid mine type.");
                        break;
                    }
                }
            } else {
                TranslatableLine.SYSTEM_MINE_EXISTS.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="settings")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine settings")
    public void settingscmd(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            SettingsGUI v2 = new SettingsGUI(p, this.rm);
            v2.openInventory(p);
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="settp")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine settp <name>")
    public void settpcmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        if (commandSender instanceof Player) {
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                m.setTeleport(((Player)commandSender).getLocation());
                m.saveData(RMine.MineData.TELEPORT);
                TranslatableLine.MINE_TELEPORT_SET.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).send(commandSender);
            } else {
                TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="setcountdown")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine setcountdown <name> <seconds>")
    public void setcountdowncmd(CommandSender commandSender, @Suggestion(value="#mines") String name, @Suggestion(value="#minecountdowns") Integer seconds) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            boolean success = m.setCountdown(seconds, true);
            if (success) {
                TranslatableLine.MINE_COUNTDOWN_SET.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).setV2(TranslatableLine.ReplacableVar.TIME.eq(String.valueOf(seconds))).send(commandSender);
            } else {
                TranslatableLine.MINE_COUNTDOWN_SET_UNSUCCESSFUL.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="resetcountdown")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine resetcountdown <name>")
    public void resetcountdowncmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            boolean success = m.resetCountdown(true);
            if (success) {
                TranslatableLine line = TranslatableLine.MINE_COUNTDOWN_SET.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName()));
                Integer countdown = m.getCountdown();
                if (countdown != null) {
                    line.setV2(TranslatableLine.ReplacableVar.TIME.eq(String.valueOf(countdown)));
                }
                line.send(commandSender);
            } else {
                TranslatableLine.MINE_COUNTDOWN_SET_UNSUCCESSFUL.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="tp")
    @Permission(value={"realmines.tp"})
    @WrongUsage(value="&c/mine tp <name>")
    public void tpmine(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        if (commandSender instanceof Player) {
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                this.rm.getMineManager().teleport((Player)commandSender, m, m.isSilent(), true);
            } else {
                TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="import", alias={"imp", "conv", "convert"})
    @Permission(value={"realmines.import"})
    @WrongUsage(value="&c/mine import <converter>")
    public void importIntoRM(CommandSender commandSender, @Suggestion(value="#converters") String name) {
        try {
            RMSupportedConverters conv = Arrays.stream(RMSupportedConverters.values()).filter(c -> c.getSourceName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Converter not found"));
            Objects.requireNonNull(conv.getConverter(this.rm)).convert(commandSender);
        }
        catch (IllegalArgumentException e) {
            TranslatableLine.SYSTEM_NO_CONVERTER_AVAILABLE.send(commandSender);
        }
    }

    @SubCommand(value="silent", alias={"s"})
    @Permission(value={"realmines.silent"})
    @WrongUsage(value="&c/mine silent <name>")
    public void silent(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            m.setSilent(!m.isSilent());
            if (!m.isSilent()) {
                TranslatableLine.SYSTEM_SILENT_OFF.setV1(TranslatableLine.ReplacableVar.MINE.eq(name)).send(commandSender);
            } else {
                TranslatableLine.SYSTEM_SILENT_ON.setV1(TranslatableLine.ReplacableVar.MINE.eq(name)).send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="silentall", alias={"sa"})
    @Permission(value={"realmines.silent"})
    @WrongUsage(value="&c/mine silentall <true/false>")
    public void silentall(CommandSender commandSender, Boolean bol) {
        for (RMine m : this.rm.getMineManager().getMines().values()) {
            m.setSilent(bol);
            if (!m.isSilent()) {
                TranslatableLine.SYSTEM_SILENT_OFF.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).send(commandSender);
                continue;
            }
            TranslatableLine.SYSTEM_SILENT_ON.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).send(commandSender);
        }
    }

    @SubCommand(value="highlight")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine highlight <name>")
    public void highlight(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        if (commandSender instanceof Player) {
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                m.setHighlight(!m.isHighlighted());
                Text.send(commandSender, m.getDisplayName() + " &r&fhighlight: " + (m.isHighlighted() ? "&aON" : "&cOFF"));
            } else {
                TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="blocks")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine blocks <name>")
    public void blocks(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        if (commandSender instanceof Player) {
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                if (m.getBlockSets().isEmpty()) {
                    return;
                }
                MineItemsGUI v = new MineItemsGUI(this.rm, (Player)commandSender, m);
                v.openInventory((Player)commandSender);
            } else {
                TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="mine", alias={"m"})
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine m <name>")
    public void minecmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        if (commandSender instanceof Player) {
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                this.rm.getGUIManager().openMine(m, (Player)commandSender);
            } else {
                TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="reset", alias={"r"})
    @Permission(value={"realmines.reset"})
    @WrongUsage(value="&c/mine reset <name>")
    public void resetcmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            m.reset(RMine.ResetCause.COMMAND);
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="rename", alias={"rn"})
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine rename <name> <new_name>")
    public void renamecmd(CommandSender commandSender, @Suggestion(value="#mines") String name, String newName) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            this.rm.getMineManager().renameMine(m, newName);
            TranslatableLine.SYSTEM_MINE_RENAMED.setV1(TranslatableLine.ReplacableVar.NAME.eq(newName)).send(commandSender);
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="delete", alias={"del"})
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine delete <name>")
    public void deletecmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            this.rm.getMineManager().deleteMine(m);
            TranslatableLine.SYSTEM_MINE_DELETED.send(commandSender);
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="clear", alias={"c"})
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine clear <name>")
    public void clearcmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            m.clear();
            TranslatableLine.SYSTEM_MINE_CLEAR.send(commandSender);
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }

    @SubCommand(value="setbounds")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine setbounds <name>")
    public void setboundscmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        if (commandSender instanceof Player) {
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                this.rm.getMineManager().setBounds(m, (Player)commandSender);
            } else {
                TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
            }
        } else {
            TranslatableLine.SYSTEM_PLAYER_ONLY.send(commandSender);
        }
    }

    @SubCommand(value="freeze")
    @Permission(value={"realmines.admin"})
    @WrongUsage(value="&c/mine freeze <name>")
    public void freezecmd(CommandSender commandSender, @Suggestion(value="#mines") String name) {
        RMine m = this.rm.getMineManager().getMine(name);
        if (m != null) {
            m.setFreezed(!m.isFreezed());
            Text.send(commandSender, TranslatableLine.SYSTEM_MINE_FREEZE.get() + (m.isFreezed() ? "&aON" : "&cOFF"));
        } else {
            TranslatableLine.SYSTEM_MINE_DOESNT_EXIST.send(commandSender);
        }
    }
}

