/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.events;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.event.MineBlockBreakEvent;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.plugin.RealMines;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockEvents
implements Listener {
    private final RealMines rm;
    private final Set<String> signset = ImmutableSet.of((Object)"pm", (Object)"pl", (Object)"bm", (Object)"br", (Object)"b", (Object)"pb", (Object[])new String[]{"tl", "sl"});

    public BlockEvents(RealMines rm) {
        this.rm = rm;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent e) {
        MineItem mi = this.rm.getMineManager().findBlockUpdate(e.getPlayer(), (Cancellable)e, e.getBlock(), true);
        if (mi != null && mi.areVanillaDropsDisabled().booleanValue()) {
            e.setDropItems(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent e) {
        this.rm.getMineManager().findBlockUpdate(e.getPlayer(), (Cancellable)e, e.getBlock(), false);
    }

    @EventHandler
    public void onFarmStep(PlayerInteractEvent e) {
        if (e.getAction() == Action.PHYSICAL && e.getClickedBlock().getType() == Material.FARMLAND) {
            this.rm.getMineManager().findBlockUpdate(e.getPlayer(), (Cancellable)e, e.getClickedBlock().getRelative(BlockFace.UP), true);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent e) {
        e.blockList().forEach(block -> this.rm.getMineManager().findBlockUpdate(null, (Cancellable)e, (Block)block, true));
    }

    @EventHandler
    public void mineBlockBreak(MineBlockBreakEvent e) {
        e.getMine().processBlockBreakEvent(e, true);
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        if (event.getLine(0).contains("[realmines]") || event.getLine(0).contains("[rm]") || event.getLine(0).contains("[RealMines]")) {
            event.setLine(0, Text.getPrefix());
            String name = event.getLine(1);
            RMine m = this.rm.getMineManager().getMine(name);
            if (m != null) {
                String modif = event.getLine(2);
                assert (modif != null);
                if (this.signset.contains(modif.toLowerCase())) {
                    m.addSign(event.getBlock(), modif);
                    m.updateSigns();
                } else {
                    String[] line = TranslatableLine.SIGNS_SETTING_NOT_FOUND.get().split("\\|");
                    event.setLine(1, Text.color(line[0]));
                    event.setLine(2, Text.color(line[1]));
                    event.setLine(3, Text.color(line[2]));
                }
            } else {
                String[] line = TranslatableLine.SIGNS_MINE_NOT_FOUND.get().split("\\|");
                event.setLine(1, Text.color(line[0]));
                event.setLine(2, Text.color(line[1]));
                event.setLine(3, Text.color(line[2]));
            }
        }
    }
}

