/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.gui;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Pagination;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DirectoryBrowserGUI {
    private static final Map<UUID, DirectoryBrowserGUI> inventories = new HashMap<UUID, DirectoryBrowserGUI>();
    static final ItemStack placeholder = Items.createItem(Material.BLACK_STAINED_GLASS_PANE, 1, "");
    static final ItemStack next = Items.createItem(Material.GREEN_STAINED_GLASS, 1, TranslatableLine.GUI_NEXT_PAGE_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Next.Description"));
    static final ItemStack back = Items.createItem(Material.YELLOW_STAINED_GLASS, 1, TranslatableLine.GUI_PREVIOUS_PAGE_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Back.Description"));
    static final ItemStack close = Items.createItem(Material.ACACIA_DOOR, 1, TranslatableLine.GUI_CLOSE_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Close.Description"));
    private final Inventory inv;
    private final UUID uuid;
    private final HashMap<Integer, File> display = new HashMap();
    private final Collection<String> allowedExtensions;
    private final FileRunnable onFileChoosen;
    int pageNumber = 0;
    Pagination<File> p;
    private File upDir;
    private File currentDir;

    public DirectoryBrowserGUI(Player p, File startDir, String title, Collection<String> allowedExtensions, FileRunnable onFileChoosen) {
        this.onFileChoosen = onFileChoosen;
        this.allowedExtensions = allowedExtensions;
        this.uuid = p.getUniqueId();
        this.inv = Bukkit.getServer().createInventory(null, 54, title);
        this.loadDirectory(startDir);
        this.register();
    }

    private void loadDirectory(File dir) {
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            return;
        }
        this.currentDir = dir;
        try {
            this.upDir = dir.getParentFile();
        }
        catch (Exception e) {
            this.upDir = null;
        }
        this.load();
    }

    public void load() {
        List<File> files = Arrays.stream(Objects.requireNonNull(this.currentDir.listFiles())).sorted(Comparator.comparingLong(File::lastModified)).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            for (String ext : this.allowedExtensions) {
                if (!f.getName().endsWith(ext)) continue;
                return true;
            }
            return false;
        }).toList();
        if (files.isEmpty()) {
            this.fillChest(Collections.emptyList());
        } else {
            this.p = new Pagination<File>(28, (Collection<File>)files);
            this.fillChest(this.p.getPage(this.pageNumber));
        }
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                HumanEntity clicker = e.getWhoClicked();
                if (clicker instanceof Player) {
                    if (e.getCurrentItem() == null) {
                        return;
                    }
                    UUID uuid = clicker.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        DirectoryBrowserGUI current = inventories.get(uuid);
                        if (e.getInventory().getHolder() != current.getInventory().getHolder()) {
                            return;
                        }
                        e.setCancelled(true);
                        Player p = (Player)clicker;
                        switch (e.getRawSlot()) {
                            case 4: {
                                if (current.currentDir.getParentFile() == null) break;
                                current.loadDirectory(current.currentDir.getParentFile());
                                break;
                            }
                            case 49: {
                                p.closeInventory();
                                break;
                            }
                            case 26: 
                            case 35: {
                                this.nextPage(current);
                                p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 50.0f, 50.0f);
                                break;
                            }
                            case 18: 
                            case 27: {
                                this.backPage(current);
                                p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 50.0f, 50.0f);
                            }
                        }
                        if (current.display.containsKey(e.getRawSlot())) {
                            File f = current.display.get(e.getRawSlot());
                            if (f.isDirectory()) {
                                current.loadDirectory(f);
                            } else {
                                p.closeInventory();
                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RealMinesAPI.getInstance().getPlugin(), () -> {
                                    try {
                                        current.onFileChoosen.fileRunnable(f);
                                    }
                                    catch (RMFailedToLoadException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }, 3L);
                            }
                        }
                    }
                }
            }

            private void backPage(DirectoryBrowserGUI asd) {
                if (asd.p.exists(asd.pageNumber - 1)) {
                    --asd.pageNumber;
                }
                asd.fillChest(asd.p.getPage(asd.pageNumber));
            }

            private void nextPage(DirectoryBrowserGUI asd) {
                if (asd.p.exists(asd.pageNumber + 1)) {
                    ++asd.pageNumber;
                }
                asd.fillChest(asd.p.getPage(asd.pageNumber));
            }

            @EventHandler
            public void onClose(InventoryCloseEvent e) {
                if (e.getPlayer() instanceof Player) {
                    if (e.getInventory() == null) {
                        return;
                    }
                    Player p = (Player)e.getPlayer();
                    UUID uuid = p.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        inventories.get(uuid).unregister();
                    }
                }
            }
        };
    }

    public void fillChest(List<File> items) {
        this.inv.clear();
        this.display.clear();
        for (int i = 0; i < 9; ++i) {
            this.inv.setItem(i, placeholder);
        }
        if (this.upDir != null) {
            this.inv.setItem(4, Items.createItem(Material.COMPASS, 1, "&fClick to go up to: " + String.valueOf(this.upDir), Collections.singletonList("&7Currently on: &7" + this.currentDir.getName())));
        }
        for (int slot : new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53, 36, 44, 9, 17}) {
            this.inv.setItem(slot, placeholder);
        }
        this.inv.setItem(18, back);
        this.inv.setItem(27, back);
        this.inv.setItem(26, next);
        this.inv.setItem(35, next);
        int slot = 0;
        for (ItemStack i : this.inv.getContents()) {
            if (i == null && !items.isEmpty()) {
                File s = items.get(0);
                this.inv.setItem(slot, Items.createItem(s.isDirectory() ? Material.CHEST : (s.getName().endsWith(".schem") || s.getName().endsWith(".schematic") ? Material.FILLED_MAP : Material.MAP), 1, (s.isDirectory() ? "&f&l" : "&f") + s.getName(), Arrays.asList("&7Last modified: " + Text.formatEpoch(s.lastModified()), s.isDirectory() ? "&7Click to open." : "&7Click to select.")));
                this.display.put(slot, s);
                items.remove(0);
            }
            ++slot;
        }
        this.inv.setItem(49, close);
    }

    public void openInventory(Player target) {
        Inventory inv = this.getInventory();
        InventoryView openInv = target.getOpenInventory();
        if (openInv != null) {
            Inventory openTop = target.getOpenInventory().getTopInventory();
            if (openTop != null && openTop.getType().name().equalsIgnoreCase(inv.getType().name())) {
                openTop.setContents(inv.getContents());
            } else {
                target.openInventory(inv);
            }
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }

    private void register() {
        inventories.put(this.uuid, this);
    }

    private void unregister() {
        inventories.remove(this.uuid);
    }

    @FunctionalInterface
    public static interface FileRunnable {
        public void fileRunnable(File var1) throws RMFailedToLoadException;
    }
}

