/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.gui;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.MineIcon;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Pagination;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.plugin.RealMines;
import joserodpt.realmines.plugin.gui.RealMinesGUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class MineListGUI {
    private static final Map<UUID, MineListGUI> inventories = new HashMap<UUID, MineListGUI>();
    static final ItemStack placeholder = Items.createItem(Material.BLACK_STAINED_GLASS_PANE, 1, "");
    static final ItemStack next = Items.createItem(Material.GREEN_STAINED_GLASS, 1, TranslatableLine.GUI_NEXT_PAGE_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Next.Description"));
    static final ItemStack back = Items.createItem(Material.YELLOW_STAINED_GLASS, 1, TranslatableLine.GUI_PREVIOUS_PAGE_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Back.Description"));
    static final ItemStack close = Items.createItem(Material.ACACIA_DOOR, 1, TranslatableLine.GUI_CLOSE_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Close.Description"));
    private final Inventory inv;
    private final UUID uuid;
    private final HashMap<Integer, MineIcon> display = new HashMap();
    int pageNumber = 0;
    Pagination<MineIcon> p;
    private final RealMines rm;
    private MineListSort so;

    public MineListGUI(RealMines rm, Player as, MineListSort so) {
        this.rm = rm;
        this.uuid = as.getUniqueId();
        this.inv = Bukkit.getServer().createInventory(null, 54, Text.pluginPrefix);
        this.load(so);
        this.register();
    }

    public void load(MineListSort so) {
        this.so = so;
        this.p = so == MineListSort.SIZE ? new Pagination(28, this.rm.getMineManager().getMineList().stream().sorted(Comparator.comparingDouble(MineIcon::getSize).reversed()).collect(Collectors.toList())) : new Pagination<MineIcon>(28, (Collection<MineIcon>)this.rm.getMineManager().getMineList());
        this.fillChest(this.p.getPage(this.pageNumber));
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                HumanEntity clicker = e.getWhoClicked();
                if (clicker instanceof Player) {
                    if (e.getCurrentItem() == null) {
                        return;
                    }
                    UUID uuid = clicker.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        MineListGUI current = inventories.get(uuid);
                        if (e.getInventory().getHolder() != current.getInventory().getHolder()) {
                            return;
                        }
                        e.setCancelled(true);
                        Player p = (Player)clicker;
                        switch (e.getRawSlot()) {
                            case 4: {
                                current.load(current.so == MineListSort.DEFAULT ? MineListSort.SIZE : MineListSort.DEFAULT);
                                break;
                            }
                            case 49: {
                                p.closeInventory();
                                RealMinesGUI rmg = new RealMinesGUI(p, current.rm);
                                rmg.openInventory(p);
                                break;
                            }
                            case 26: 
                            case 35: {
                                this.nextPage(current);
                                p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 50.0f, 50.0f);
                                break;
                            }
                            case 18: 
                            case 27: {
                                this.backPage(current);
                                p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 50.0f, 50.0f);
                            }
                        }
                        if (current.display.containsKey(e.getRawSlot())) {
                            MineIcon icon = current.display.get(e.getRawSlot());
                            if (icon.getMine() == null) {
                                return;
                            }
                            if (e.getClick() == ClickType.DROP) {
                                current.rm.getMineManager().deleteMine(icon.getMine());
                                TranslatableLine.SYSTEM_MINE_DELETED.send((CommandSender)p);
                                current.load(current.so);
                            } else {
                                p.closeInventory();
                                current.rm.getGUIManager().openMine(current.display.get(e.getRawSlot()).getMine(), p);
                            }
                        }
                    }
                }
            }

            private void backPage(MineListGUI asd) {
                if (asd.p.exists(asd.pageNumber - 1)) {
                    --asd.pageNumber;
                }
                asd.fillChest(asd.p.getPage(asd.pageNumber));
            }

            private void nextPage(MineListGUI asd) {
                if (asd.p.exists(asd.pageNumber + 1)) {
                    ++asd.pageNumber;
                }
                asd.fillChest(asd.p.getPage(asd.pageNumber));
            }

            @EventHandler
            public void onClose(InventoryCloseEvent e) {
                if (e.getPlayer() instanceof Player) {
                    if (e.getInventory() == null) {
                        return;
                    }
                    Player p = (Player)e.getPlayer();
                    UUID uuid = p.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        inventories.get(uuid).unregister();
                    }
                }
            }
        };
    }

    public void fillChest(List<MineIcon> items) {
        this.inv.clear();
        this.display.clear();
        for (int i = 0; i < 9; ++i) {
            this.inv.setItem(i, placeholder);
        }
        this.inv.setItem(4, Items.createItem(Material.COMPARATOR, 1, "&fClick to sort by: &b" + (this.so == MineListSort.DEFAULT ? "Size" : "Default")));
        for (int slot : new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53, 36, 44, 9, 17}) {
            this.inv.setItem(slot, placeholder);
        }
        this.inv.setItem(18, back);
        this.inv.setItem(27, back);
        this.inv.setItem(26, next);
        this.inv.setItem(35, next);
        int slot = 0;
        for (ItemStack i : this.inv.getContents()) {
            if (i == null && !items.isEmpty()) {
                MineIcon s = items.get(0);
                this.inv.setItem(slot, s.getMineItem());
                this.display.put(slot, s);
                items.remove(0);
            }
            ++slot;
        }
        this.inv.setItem(49, close);
    }

    public void openInventory(Player target) {
        Inventory inv = this.getInventory();
        InventoryView openInv = target.getOpenInventory();
        if (openInv != null) {
            Inventory openTop = target.getOpenInventory().getTopInventory();
            if (openTop != null && openTop.getType().name().equalsIgnoreCase(inv.getType().name())) {
                openTop.setContents(inv.getContents());
            } else {
                target.openInventory(inv);
            }
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }

    private void register() {
        inventories.put(this.uuid, this);
    }

    private void unregister() {
        inventories.remove(this.uuid);
    }

    public static enum MineListSort {
        DEFAULT,
        SIZE;

    }
}

