/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.PlayerInput;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.plugin.RealMines;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class MineResetGUI {
    private static final Map<UUID, MineResetGUI> inventories = new HashMap<UUID, MineResetGUI>();
    private final Inventory inv;
    private final UUID uuid;
    private final RMine min;
    private final RealMines rm;

    public MineResetGUI(RealMines rm, Player as, RMine m) {
        this.rm = rm;
        this.uuid = as.getUniqueId();
        this.inv = Bukkit.getServer().createInventory(null, InventoryType.HOPPER, TranslatableLine.GUI_RESET_NAME.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).get());
        this.min = m;
        this.load(m);
        this.register();
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                HumanEntity clicker = e.getWhoClicked();
                if (clicker instanceof Player) {
                    if (e.getCurrentItem() == null) {
                        return;
                    }
                    UUID uuid = clicker.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        MineResetGUI current = inventories.get(uuid);
                        if (e.getInventory().getHolder() != current.getInventory().getHolder()) {
                            return;
                        }
                        e.setCancelled(true);
                        Player gp = (Player)clicker;
                        block0 : switch (e.getRawSlot()) {
                            case 2: {
                                gp.closeInventory();
                                current.rm.getGUIManager().openMine(current.min, gp);
                                break;
                            }
                            case 0: {
                                switch (e.getClick()) {
                                    case LEFT: {
                                        current.min.setResetState(RMine.Reset.PERCENTAGE, !current.min.isResetBy(RMine.Reset.PERCENTAGE));
                                        current.load(current.min);
                                        break;
                                    }
                                    case RIGHT: {
                                        current.editSetting(current.rm, 0, gp, current.min);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                switch (e.getClick()) {
                                    case LEFT: {
                                        current.min.setResetState(RMine.Reset.TIME, !current.min.isResetBy(RMine.Reset.TIME));
                                        current.load(current.min);
                                        break block0;
                                    }
                                    case RIGHT: {
                                        current.editSetting(current.rm, 1, gp, current.min);
                                        break block0;
                                    }
                                }
                            }
                        }
                    }
                }
            }

            @EventHandler
            public void onClose(InventoryCloseEvent e) {
                if (e.getPlayer() instanceof Player) {
                    if (e.getInventory() == null) {
                        return;
                    }
                    Player p = (Player)e.getPlayer();
                    UUID uuid = p.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        inventories.get(uuid).unregister();
                    }
                }
            }
        };
    }

    public void load(RMine m) {
        this.inv.clear();
        ArrayList<String> percentageOnDesc = new ArrayList<String>();
        ArrayList<String> percentageOffDesc = new ArrayList<String>();
        ArrayList<String> timeOnDesc = new ArrayList<String>();
        ArrayList<String> timeOffDesc = new ArrayList<String>();
        for (String s : RMLanguageConfig.file().getStringList("GUI.Resets.Percentage-On.Description")) {
            percentageOnDesc.add(s.replaceAll("%value%", String.valueOf(m.getResetValue(RMine.Reset.PERCENTAGE))));
        }
        for (String s : RMLanguageConfig.file().getStringList("GUI.Resets.Percentage-Off.Description")) {
            percentageOffDesc.add(s.replaceAll("%value%", String.valueOf(m.getResetValue(RMine.Reset.PERCENTAGE))));
        }
        for (String s : RMLanguageConfig.file().getStringList("GUI.Resets.Time-On.Description")) {
            timeOnDesc.add(s.replaceAll("%value%", String.valueOf(m.getResetValue(RMine.Reset.TIME))));
        }
        for (String s : RMLanguageConfig.file().getStringList("GUI.Resets.Time-Off.Description")) {
            timeOffDesc.add(s.replaceAll("%value%", String.valueOf(m.getResetValue(RMine.Reset.TIME))));
        }
        this.inv.setItem(0, m.isResetBy(RMine.Reset.PERCENTAGE) ? Items.createItemLoreEnchanted(Material.BOOK, 1, TranslatableLine.GUI_RESET_BY_PERCENTAGE_ON.get(), percentageOnDesc) : Items.createItem(Material.BOOK, 1, TranslatableLine.GUI_RESET_BY_PERCENTAGE_OFF.get(), percentageOffDesc));
        this.inv.setItem(4, m.isResetBy(RMine.Reset.TIME) ? Items.createItemLoreEnchanted(Material.CLOCK, 1, TranslatableLine.GUI_RESET_BY_TIME_ON.get(), timeOnDesc) : Items.createItem(Material.CLOCK, 1, TranslatableLine.GUI_RESET_BY_TIME_OFF.get(), timeOffDesc));
        this.inv.setItem(2, Items.createItem(Material.ACACIA_DOOR, 1, TranslatableLine.GUI_GO_BACK_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.Go-Back.Description")));
    }

    public void openInventory(Player target) {
        Inventory inv = this.getInventory();
        InventoryView openInv = target.getOpenInventory();
        if (openInv != null) {
            Inventory openTop = target.getOpenInventory().getTopInventory();
            if (openTop != null && openTop.getType().name().equalsIgnoreCase(inv.getType().name())) {
                openTop.setContents(inv.getContents());
            } else {
                target.openInventory(inv);
            }
        }
    }

    protected void editSetting(RealMines rm, int i, Player p, RMine m) {
        switch (i) {
            case 0: {
                new PlayerInput(true, p, s -> {
                    int d;
                    try {
                        d = Integer.parseInt(s.replace("%", ""));
                    }
                    catch (Exception ex) {
                        TranslatableLine.SYSTEM_INPUT_PARSE.send((CommandSender)p);
                        this.editSetting(rm, 0, p, m);
                        return;
                    }
                    if (d < 1 || d > 100) {
                        TranslatableLine.SYSTEM_INPUT_LIMIT_ERROR.send((CommandSender)p);
                        this.editSetting(rm, 0, p, m);
                        return;
                    }
                    m.setResetValue(RMine.Reset.PERCENTAGE, d);
                    TranslatableLine.SYSTEM_PERCENTAGE_MODIFIED.setV1(TranslatableLine.ReplacableVar.VALUE.eq(Text.formatPercentages(d) + "%")).send((CommandSender)p);
                    MineResetGUI v = new MineResetGUI(rm, p, m);
                    v.openInventory(p);
                }, s -> {
                    MineResetGUI v = new MineResetGUI(rm, p, m);
                    v.openInventory(p);
                });
                break;
            }
            case 1: {
                new PlayerInput(true, p, s -> {
                    int d;
                    try {
                        d = Integer.parseInt(s.replace("%", ""));
                    }
                    catch (Exception ex) {
                        TranslatableLine.SYSTEM_INPUT_SECONDS.send((CommandSender)p);
                        this.editSetting(rm, 1, p, m);
                        return;
                    }
                    if (d < 1) {
                        TranslatableLine.SYSTEM_INPUT_LIMIT_ERROR_GREATER.send((CommandSender)p);
                        this.editSetting(rm, 1, p, m);
                        return;
                    }
                    m.setResetValue(RMine.Reset.TIME, d);
                    TranslatableLine.SYSTEM_TIME_MODIFIED.setV1(TranslatableLine.ReplacableVar.VALUE.eq(String.valueOf(d))).send((CommandSender)p);
                    MineResetGUI v = new MineResetGUI(rm, p, m);
                    v.openInventory(p);
                }, s -> {
                    MineResetGUI v = new MineResetGUI(rm, p, m);
                    v.openInventory(p);
                });
                break;
            }
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }

    private void register() {
        inventories.put(this.uuid, this);
    }

    private void unregister() {
        inventories.remove(this.uuid);
    }
}

