/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.managers;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.Region;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.config.RMMinesOldConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.event.MineBlockBreakEvent;
import joserodpt.realmines.api.event.RealMinesMineChangeEvent;
import joserodpt.realmines.api.managers.MineManagerAPI;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.MineIcon;
import joserodpt.realmines.api.mine.components.MineSign;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.mine.components.RMineSettings;
import joserodpt.realmines.api.mine.components.items.MineBlockItem;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.mine.components.items.farm.MineFarmItem;
import joserodpt.realmines.api.mine.task.MineResetTask;
import joserodpt.realmines.api.mine.types.BlockMine;
import joserodpt.realmines.api.mine.types.SchematicMine;
import joserodpt.realmines.api.mine.types.farm.FarmItem;
import joserodpt.realmines.api.mine.types.farm.FarmMine;
import joserodpt.realmines.api.utils.PlayerInput;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.plugin.gui.DirectoryBrowserGUI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class MineManager
extends MineManagerAPI {
    private final RealMinesAPI rm;
    private final Map<String, RMine> mines = new HashMap<String, RMine>();

    public MineManager(RealMinesAPI rm) {
        this.rm = rm;
    }

    @Override
    public List<String> getRegisteredMines() {
        return this.getMines().values().stream().map(RMine::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMines() {
        if (RMMinesOldConfig.fileExists() && RMMinesOldConfig.file() != null) {
            this.rm.getLogger().warning("Converting mines into the new format...");
            for (String mineName : RMMinesOldConfig.file().getRoot().getRoutesAsStrings(false)) {
                String type;
                this.rm.getLogger().warning("Converting mine " + mineName + " into the new format...");
                String mtyp = RMMinesOldConfig.file().getString(mineName + ".Type");
                if (mtyp == null || mtyp.isEmpty()) {
                    type = "BLOCKS";
                    this.rm.getPlugin().getLogger().warning(mineName + " converted into the new mine block type.");
                } else {
                    type = mtyp;
                }
                Section mineConfigSection = RMMinesOldConfig.file().getSection(mineName);
                try {
                    switch (type) {
                        case "BLOCKS": {
                            this.mines.put(mineName, new BlockMine(mineName, mineConfigSection));
                            break;
                        }
                        case "SCHEMATIC": {
                            this.mines.put(mineName, new SchematicMine(mineName, mineConfigSection));
                            break;
                        }
                        case "FARM": {
                            this.mines.put(mineName, new FarmMine(mineName, mineConfigSection));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + type);
                        }
                    }
                }
                catch (RMFailedToLoadException e) {
                    this.rm.getLogger().severe("Failed to load mine " + mineName + "!");
                    this.rm.getLogger().severe("Error: " + e.getMessage());
                }
                this.rm.getLogger().info("Mine " + mineName + " converted into the new format!");
            }
            RMMinesOldConfig.delete();
            this.rm.getLogger().warning("Conversion finished with success.");
        } else {
            File minesFolder = new File(this.rm.getPlugin().getDataFolder(), "mines");
            if (!minesFolder.exists()) {
                minesFolder.mkdirs();
            }
            for (File file : minesFolder.listFiles()) {
                if (!file.getName().endsWith(".yml")) continue;
                try {
                    YamlConfiguration mineConfig = YamlConfiguration.loadConfiguration((File)file);
                    String mineName = mineConfig.getString("name");
                    String type = mineConfig.getString("type");
                    if (mineName == null || type == null) {
                        this.rm.getLogger().warning("Failed to load mine " + file.getName() + "!");
                        this.rm.getLogger().warning("Error: name or type not found.");
                        continue;
                    }
                    switch (type) {
                        case "BLOCKS": {
                            this.addMine(new BlockMine(mineName, mineConfig));
                            break;
                        }
                        case "SCHEMATIC": {
                            this.addMine(new SchematicMine(mineName, mineConfig));
                            break;
                        }
                        case "FARM": {
                            this.addMine(new FarmMine(mineName, mineConfig));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + type);
                        }
                    }
                }
                catch (RMFailedToLoadException e) {
                    this.rm.getLogger().severe("Failed to load mine " + file.getName() + "!");
                    this.rm.getLogger().severe("Error: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void createMine(Player p, String name) {
        WorldEditPlugin w = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
        try {
            Region r = w.getSession(p.getPlayer()).getSelection(w.getSession(p.getPlayer()).getSelectionWorld());
            if (r != null) {
                Location pos1 = new Location(p.getWorld(), (double)r.getMaximumPoint().getBlockX(), (double)r.getMaximumPoint().getBlockY(), (double)r.getMaximumPoint().getBlockZ());
                Location pos2 = new Location(p.getWorld(), (double)r.getMinimumPoint().getBlockX(), (double)r.getMinimumPoint().getBlockY(), (double)r.getMinimumPoint().getBlockZ());
                BlockMine m = new BlockMine(name, p.getWorld(), pos1, pos2);
                m.addItem("default", new MineBlockItem(Material.STONE, 1.0));
                m.reset(RMine.ResetCause.CREATION);
                m.setTeleport(p.getLocation());
                this.addMine(m);
                Bukkit.getPluginManager().callEvent((Event)new RealMinesMineChangeEvent(m, RealMinesMineChangeEvent.ChangeOperation.ADDED));
                List<Material> mat = m.getMineCuboid().getBlockTypes();
                if (!mat.isEmpty()) {
                    TranslatableLine.SYSTEM_ADD_BLOCKS.send((CommandSender)p);
                    mat.forEach(material -> Text.send((CommandSender)p, " &7> &f" + material.name()));
                    TranslatableLine.SYSTEM_BLOCK_COUNT.setV1(TranslatableLine.ReplacableVar.COUNT.eq(String.valueOf(mat.size()))).send((CommandSender)p);
                    new PlayerInput(true, p, input -> {
                        if (input.equalsIgnoreCase("yes")) {
                            mat.forEach(material -> m.addItem("default", new MineBlockItem((Material)material, 0.1)));
                            TranslatableLine.SYSTEM_BLOCKS_ADDED.setV1(TranslatableLine.ReplacableVar.COUNT.eq(String.valueOf(mat.size()))).send((CommandSender)p);
                        }
                        TranslatableLine.SYSTEM_MINE_CREATED.setV1(TranslatableLine.ReplacableVar.MINE.eq(name)).send((CommandSender)p);
                    }, input -> TranslatableLine.SYSTEM_MINE_CREATED.setV1(TranslatableLine.ReplacableVar.MINE.eq(name)).send((CommandSender)p));
                }
            }
        }
        catch (Exception ignored) {
            TranslatableLine.SYSTEM_BOUNDARIES_NOT_SET.send((CommandSender)p);
        }
    }

    @Override
    public void createFarmMine(Player p, String name) {
        WorldEditPlugin w = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
        try {
            Region r = w.getSession(p.getPlayer()).getSelection(w.getSession(p.getPlayer()).getSelectionWorld());
            if (r != null) {
                Location pos1 = new Location(p.getWorld(), (double)r.getMaximumPoint().getBlockX(), (double)r.getMaximumPoint().getBlockY(), (double)r.getMaximumPoint().getBlockZ());
                Location pos2 = new Location(p.getWorld(), (double)r.getMinimumPoint().getBlockX(), (double)r.getMinimumPoint().getBlockY(), (double)r.getMinimumPoint().getBlockZ());
                if (pos1.getY() != pos2.getY()) {
                    pos1.add(0.0, 1.0, 0.0);
                }
                FarmMine m = new FarmMine(name, p.getWorld(), pos1, pos2);
                m.addFarmItem("default", new MineFarmItem(FarmItem.WHEAT, (Double)1.0));
                this.addMine(m);
                m.reset(RMine.ResetCause.CREATION);
                m.setTeleport(p.getLocation());
                Bukkit.getPluginManager().callEvent((Event)new RealMinesMineChangeEvent(m, RealMinesMineChangeEvent.ChangeOperation.ADDED));
                List<Material> mat = m.getMineCuboid().getBlockTypes();
                if (!mat.isEmpty()) {
                    TranslatableLine.SYSTEM_ADD_BLOCKS.send((CommandSender)p);
                    mat.forEach(material -> Text.send((CommandSender)p, " &7> &f" + material.name()));
                    TranslatableLine.SYSTEM_BLOCK_COUNT.setV1(TranslatableLine.ReplacableVar.COUNT.eq(String.valueOf(mat.size()))).send((CommandSender)p);
                    new PlayerInput(true, p, input -> {
                        if (input.equalsIgnoreCase("yes")) {
                            mat.forEach(material -> m.addFarmItem("default", new MineFarmItem(FarmItem.valueOf(Material.WHEAT))));
                            TranslatableLine.SYSTEM_BLOCKS_ADDED.setV1(TranslatableLine.ReplacableVar.COUNT.eq(String.valueOf(mat.size()))).send((CommandSender)p);
                        }
                        TranslatableLine.SYSTEM_MINE_CREATED.setV1(TranslatableLine.ReplacableVar.MINE.eq(name)).send((CommandSender)p);
                    }, input -> TranslatableLine.SYSTEM_MINE_CREATED.setV1(TranslatableLine.ReplacableVar.MINE.eq(name)).send((CommandSender)p));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TranslatableLine.SYSTEM_BOUNDARIES_NOT_SET.send((CommandSender)p);
        }
    }

    @Override
    public void createSchematicMine(Player p, String name) {
        File pluginFolder = new File(this.rm.getPlugin().getDataFolder(), "schematics");
        DirectoryBrowserGUI dbg = new DirectoryBrowserGUI(p, pluginFolder, "Please select a schematic", Arrays.asList("schem", "schematic"), file -> {
            File finalFile;
            block7: {
                finalFile = null;
                if (!file.getAbsolutePath().toLowerCase().contains("realmines")) {
                    try {
                        if (pluginFolder.exists() && pluginFolder.isDirectory()) {
                            finalFile = new File(pluginFolder, file.getName());
                            Files.copy(file.toPath(), finalFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            break block7;
                        }
                        Bukkit.getLogger().warning("The plugin shematic's folder is not a directory or does not exist.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    finalFile = file;
                }
            }
            if (finalFile != null && finalFile.exists()) {
                SchematicMine m = new SchematicMine(name, p.getLocation(), finalFile.getName());
                this.addMine(m);
                m.setTeleport(p.getLocation());
                m.reset(RMine.ResetCause.CREATION);
                Bukkit.getPluginManager().callEvent((Event)new RealMinesMineChangeEvent(m, RealMinesMineChangeEvent.ChangeOperation.ADDED));
            } else {
                TranslatableLine.SYSTEM_INVALID_SCHEMATIC.send((CommandSender)p);
            }
        });
        dbg.openInventory(p);
    }

    @Override
    public List<MineIcon> getMineList() {
        return this.getMines().isEmpty() ? Collections.singletonList(new MineIcon()) : (List)this.getMines().values().stream().map(MineIcon::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void teleport(Player target, RMine m, Boolean silent, Boolean checkForPermission) {
        if (!silent.booleanValue()) {
            if (m.hasTP()) {
                if (checkForPermission.booleanValue()) {
                    if (target.hasPermission("realmines.tp." + m.getName())) {
                        target.teleport(m.getTeleport());
                        if (RMConfig.file().getBoolean("RealMines.teleportMessage").booleanValue()) {
                            TranslatableLine.MINE_TELEPORT.setV1(TranslatableLine.ReplacableVar.MINE.eq(m.getDisplayName())).send((CommandSender)target);
                        }
                    } else if (RMConfig.file().getBoolean("RealMines.teleportMessage").booleanValue()) {
                        TranslatableLine.SYSTEM_ERROR_PERMISSION.send((CommandSender)target);
                    }
                } else {
                    target.teleport(m.getTeleport());
                }
            } else {
                TranslatableLine.MINE_NO_TELEPORT_LOCATION.send((CommandSender)target);
            }
        } else if (m.hasTP()) {
            target.teleport(m.getTeleport());
        }
    }

    @Override
    public RMine getMine(String name) {
        return this.getMines().getOrDefault(name, null);
    }

    @Override
    public MineItem findBlockUpdate(Player p, Cancellable e, Block block, boolean broken) {
        for (RMine mine : this.getMines().values()) {
            if (mine.getMineCuboid() == null || !mine.getMineCuboid().contains(block)) continue;
            if (mine.getSettingBool(RMineSettings.BREAK_PERMISSION) && !p.hasPermission(mine.getBreakPermission()) || mine.getSettingBool(RMineSettings.BLOCK_SETS_MODE) && !mine.getMineCuboid().getBlockTypes().contains(block.getType())) {
                e.setCancelled(true);
                TranslatableLine.SYSTEM_ERROR_BREAK_PERMISSION.send((CommandSender)p);
                return null;
            }
            if (mine.isFreezed()) {
                e.setCancelled(true);
            } else if (mine.getType() == RMine.Type.FARM && !FarmItem.getCrops().contains(block.getType())) {
                e.setCancelled(true);
            } else {
                MineItem mi = mine.getMineItems().get(mine.getType() == RMine.Type.FARM ? FarmItem.getIconFromCrop(block.getType()) : block.getType());
                if (mi != null) {
                    if (mi.isBlockMiningDisabled().booleanValue()) {
                        e.setCancelled(true);
                    } else {
                        Bukkit.getPluginManager().callEvent((Event)new MineBlockBreakEvent(p, mine, block, broken));
                        return mine.getMineItems().get(block.getType());
                    }
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public List<MineSign> getSigns() {
        return this.getMines().values().stream().flatMap(mine -> mine.getSigns().stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void unloadMines() {
        for (RMine mine : this.getMines().values()) {
            mine.saveData(RMine.MineData.COUNTDOWN);
            if (mine.getMineTimer() == null) continue;
            mine.getMineTimer().kill();
        }
        this.clearMemory();
    }

    @Override
    public void setBounds(RMine m, Player p) {
        if (m.getType() == RMine.Type.SCHEMATIC) {
            return;
        }
        WorldEditPlugin w = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
        try {
            LocalSession localSession = w.getSession(p.getPlayer());
            Region r = localSession.getSelection(BukkitAdapter.adapt((World)p.getWorld()));
            if (r != null) {
                Location pos1 = new Location(p.getWorld(), (double)r.getMaximumPoint().getBlockX(), (double)r.getMaximumPoint().getBlockY(), (double)r.getMaximumPoint().getBlockZ());
                Location pos2 = new Location(p.getWorld(), (double)r.getMinimumPoint().getBlockX(), (double)r.getMinimumPoint().getBlockY(), (double)r.getMinimumPoint().getBlockZ());
                m.setPOS(pos1, pos2);
                m.fillContent();
                TranslatableLine.SYSTEM_REGION_UPDATED.send((CommandSender)p);
                m.reset();
                m.saveData(RMine.MineData.POS);
                Bukkit.getPluginManager().callEvent((Event)new RealMinesMineChangeEvent(m, RealMinesMineChangeEvent.ChangeOperation.BOUNDS_UPDATED));
            }
        }
        catch (Exception e) {
            TranslatableLine.SYSTEM_BOUNDARIES_NOT_SET.send((CommandSender)p);
        }
    }

    @Override
    public void stopTasks() {
        this.getMines().values().stream().filter(mine -> mine.getMineTimer() != null).forEach(mine -> mine.getMineTimer().kill());
    }

    @Override
    public void startTasks() {
        this.getMines().values().forEach(mine -> mine.getMineTimer().start());
    }

    @Override
    public void deleteMine(RMine mine) {
        if (mine != null) {
            Bukkit.getPluginManager().callEvent((Event)new RealMinesMineChangeEvent(mine, RealMinesMineChangeEvent.ChangeOperation.REMOVED));
            if (RMConfig.file().getBoolean("RealMines.disableMineClearingWhenDeleting", (Boolean)false).booleanValue()) {
                mine.clear();
            }
            if (mine.getMineTimer() != null) {
                mine.getMineTimer().kill();
            }
            if (mine.getSigns() != null || !mine.getSigns().isEmpty()) {
                mine.getSigns().forEach(ms -> ms.getBlock().getLocation().getWorld().getBlockAt(ms.getBlock().getLocation()).setType(Material.AIR));
            }
            for (MineResetTask task : this.rm.getMineResetTasksManager().getTasks()) {
                if (!task.hasMine(mine)) continue;
                task.removeMine(mine);
            }
            this.unregisterMine(mine);
        }
    }

    @Override
    public void clearMemory() {
        this.mines.clear();
    }

    @Override
    public Map<String, RMine> getMines() {
        return this.mines;
    }

    @Override
    public void addMine(RMine mine) {
        this.mines.put(mine.getName(), mine);
    }

    @Override
    public File getSchematicFolder() {
        return this.rm.getPlugin().getDataFolder();
    }

    @Override
    public void renameMine(RMine m, String newName) {
        this.unregisterMine(m);
        m.rename(ChatColor.stripColor((String)Text.color(newName)));
        this.registerMine(m);
    }

    @Override
    public void unregisterMine(RMine m) {
        m.deleteConfig();
        this.getMines().remove(m.getName());
    }

    @Override
    public void registerMine(RMine m) {
        this.addMine(m);
        m.saveData(RMine.MineData.ALL);
    }
}

