/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.plugin.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import joserodpt.realmines.api.config.RPMineResetTasksConfig;
import joserodpt.realmines.api.managers.MineResetTasksManagerAPI;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.task.MineResetTask;
import joserodpt.realmines.plugin.RealMines;

public class MineResetTasksManager
extends MineResetTasksManagerAPI {
    private final RealMines rm;
    public List<MineResetTask> tasks = new ArrayList<MineResetTask>();

    public MineResetTasksManager(RealMines rm) {
        this.rm = rm;
    }

    @Override
    public void addTask(String name, Integer i) {
        this.tasks.add(new MineResetTask(this.rm, name, i, true));
    }

    @Override
    public void loadTasks() {
        if (RPMineResetTasksConfig.file().isSection("")) {
            for (String s : RPMineResetTasksConfig.file().getSection("").getRoutesAsStrings(false)) {
                int interval = RPMineResetTasksConfig.file().getInt(s + ".Delay");
                MineResetTask mrt = new MineResetTask(this.rm, s, interval, false);
                for (String s1 : RPMineResetTasksConfig.file().getStringList(s + ".LinkedMines")) {
                    RMine m = this.rm.getMineManager().getMine(s1);
                    if (m == null) continue;
                    mrt.addMine(m);
                }
                this.tasks.add(mrt);
            }
        }
    }

    @Override
    public MineResetTask getTask(String name) {
        return this.tasks.stream().filter(task -> task.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public List<String> getRegisteredTasks() {
        RPMineResetTasksConfig.reload();
        return this.tasks.stream().map(MineResetTask::getName).collect(Collectors.toList());
    }

    @Override
    public void removeTask(MineResetTask mrt) {
        String name = mrt.getName();
        mrt.stopTimer();
        mrt.clearLinks();
        this.tasks.remove(mrt);
        RPMineResetTasksConfig.file().set(name, null);
        RPMineResetTasksConfig.save();
    }

    @Override
    public List<MineResetTask> getTasks() {
        return this.tasks;
    }
}

