/*
 * Decompiled with CFR 0.152.
 */
package fr.euphyllia.skyllia_insight_addon;

import dev.frankheijden.insights.api.addons.InsightsAddon;
import dev.frankheijden.insights.api.addons.Region;
import dev.frankheijden.insights.api.objects.chunk.ChunkLocation;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import fr.euphyllia.skyllia.api.SkylliaAPI;
import fr.euphyllia.skyllia.api.skyblock.Island;
import fr.euphyllia.skyllia.api.skyblock.model.Position;
import fr.euphyllia.skyllia.api.utils.helper.RegionHelper;
import fr.euphyllia.skyllia.configuration.ConfigLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class SkylliaInsightAddon
implements InsightsAddon {
    public String getPluginName() {
        return "Skyllia";
    }

    public String getAreaName() {
        return "island";
    }

    public String getVersion() {
        return "1.0";
    }

    public Optional<Region> getRegion(Location location) {
        if (!SkylliaAPI.isWorldSkyblock((World)location.getWorld()).booleanValue()) {
            return Optional.empty();
        }
        Island island = SkylliaAPI.getIslandByChunk((Chunk)location.getChunk());
        if (island == null) {
            return Optional.empty();
        }
        return Optional.of(new SkylliaRegion(island, location.getWorld()));
    }

    public class SkylliaRegion
    implements Region {
        private final Island island;
        private final World world;

        public SkylliaRegion(Island island, World world) {
            this.island = island;
            this.world = world;
        }

        public static List<Position> spiralStartCenter(Position islandRegion, double size) {
            ArrayList<Position> positions = new ArrayList<Position>();
            Position chunk = RegionHelper.getCenterChunkOfRegion((int)islandRegion.x(), (int)islandRegion.z());
            int cx = chunk.x();
            int cz = chunk.z();
            int x = 0;
            int z = 0;
            int dx = 0;
            int dz = -1;
            int maxI = (int)Math.pow(33 * ConfigLoader.general.getRegionDistance(), 2.0);
            List islandPositionWithRadius = RegionHelper.getRegionsWithinBlockRange((Position)islandRegion, (int)((int)Math.round(size)));
            ArrayList<Position> regionCleaned = new ArrayList<Position>();
            for (int i = 0; i < maxI; ++i) {
                Position chunkPos;
                Position region;
                if (-size / 2.0 <= (double)x && (double)x <= size / 2.0 && -size / 2.0 <= (double)z && (double)z <= size / 2.0 && islandPositionWithRadius.contains(region = RegionHelper.getRegionFromChunk((int)(chunkPos = new Position(cx + x, cz + z)).x(), (int)chunkPos.z()))) {
                    if (!regionCleaned.contains(region)) {
                        regionCleaned.add(region);
                    }
                    positions.add(chunkPos);
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int temp = dx;
                    dx = -dz;
                    dz = temp;
                }
                x += dx;
                z += dz;
            }
            return positions;
        }

        public String getAddon() {
            return SkylliaInsightAddon.this.getPluginName();
        }

        public String getKey() {
            return "SKYLLIA_%s".formatted(this.island.getId());
        }

        public List<ChunkPart> toChunkParts() {
            ArrayList<ChunkPart> parts = new ArrayList<ChunkPart>();
            for (Position position : SkylliaRegion.spiralStartCenter(this.island.getPosition(), this.island.getSize())) {
                parts.add(new ChunkPart(new ChunkLocation(this.world, position.x(), position.z())));
            }
            return parts;
        }
    }
}

