/*
 * Decompiled with CFR 0.152.
 */
package net.tuples.captcha;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8494;
import net.tuples.captcha.Captcha;
import net.tuples.captcha.CaptchaData;
import net.tuples.captcha.sounds.CaptchaSounds;

@Environment(value=EnvType.CLIENT)
public class CaptchaScreen
extends class_437 {
    private class_7845 gridDisplay;
    private final Map<CaptchaImageButton, Boolean> buttonStates = new LinkedHashMap<CaptchaImageButton, Boolean>();
    private final int cellSize = 32;
    private final int cellSpacing = 5;
    private int gridSize;
    private JsonObject captcha;
    private String captchaId;
    private final Map<String, Boolean> captchaKey = new LinkedHashMap<String, Boolean>();
    private final class_310 client;
    private class_1144 soundManager;
    private class_1113 sound;
    private final class_4185 confirm = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Skip"), button -> {
        ArrayList<Boolean> correctValues = new ArrayList<Boolean>(this.captchaKey.values());
        boolean allMatch = true;
        int index = 0;
        for (Map.Entry<CaptchaImageButton, Boolean> entry : this.buttonStates.entrySet()) {
            if (entry.getValue() != correctValues.get(index)) {
                allMatch = false;
                break;
            }
            ++index;
        }
        if (allMatch) {
            if (Captcha.config.soundEffects) {
                this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)CaptchaSounds.sounds.get("button3"), (float)1.0f, (float)0.6f));
            }
            this.method_25419();
        } else {
            if (Captcha.config.soundEffects) {
                this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)CaptchaSounds.sounds.get("button10"), (float)1.0f, (float)0.6f));
            }
            this.newCaptcha();
        }
    }).method_46434(0, 0, 80, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)":)"))).method_46431();

    public CaptchaScreen() {
        super((class_2561)class_2561.method_43471((String)"captcha.narrator.title"));
        this.client = class_310.method_1551();
        this.soundManager = this.client.method_1483();
        if (Captcha.config.soundEffects) {
            this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)CaptchaSounds.sounds.get("blip1"), (float)1.0f, (float)0.6f));
        }
        this.newCaptcha();
    }

    private void newCaptcha() {
        this.confirm.method_25355((class_2561)class_2561.method_43471((String)"captcha.ui.button.confirm"));
        this.buttonStates.keySet().forEach(x$0 -> this.method_37066((class_364)x$0));
        this.buttonStates.clear();
        this.gridDisplay = new class_7845().method_48637(5);
        ArrayList keys = new ArrayList(CaptchaData.captchas.keySet());
        if (this.captchaId != null) {
            keys.remove(this.captchaId);
        }
        int rand = new Random().nextInt(keys.size());
        this.captchaId = (String)keys.get(rand);
        this.captcha = CaptchaData.captchas.get(this.captchaId).getAsJsonObject();
        this.captchaKey.clear();
        for (Map.Entry entry : this.captcha.get("images").getAsJsonObject().entrySet()) {
            this.captchaKey.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
        }
        if (this.captcha.get("creep").getAsBoolean()) {
            if (this.client.field_1687 != null && this.client.field_1724 != null) {
                int randSound = new Random().nextInt(CaptchaSounds.whisper_sounds.size());
                if (this.soundManager.method_4877(this.sound)) {
                    this.soundManager.method_4870(this.sound);
                }
                this.sound = class_1109.method_4757((class_3414)CaptchaSounds.whisper_sounds.get(randSound), (float)1.0f, (float)0.3f);
                this.soundManager.method_4873(this.sound);
            }
        } else if (this.soundManager.method_4877(this.sound)) {
            this.soundManager.method_4870(this.sound);
        }
        this.initializeButtons();
        this.updateElements();
    }

    private void initializeButtons() {
        ArrayList<String> imagePaths = new ArrayList<String>(this.captchaKey.keySet());
        this.gridSize = (int)Math.ceil(Math.sqrt(imagePaths.size()));
        for (int i = 0; i < imagePaths.size(); ++i) {
            class_2960 image = class_2960.method_60654((String)((String)imagePaths.get(i)));
            CaptchaImageButton button = new CaptchaImageButton(0, 0, 32, 32, image, b -> {
                this.buttonStates.put((CaptchaImageButton)b, this.buttonStates.getOrDefault(b, false) == false);
                if (this.buttonStates.containsValue(true)) {
                    this.confirm.method_25355((class_2561)class_2561.method_43471((String)"captcha.ui.button.confirm"));
                } else {
                    this.confirm.method_25355((class_2561)class_2561.method_43471((String)"captcha.ui.button.skip"));
                }
            });
            this.buttonStates.put(button, false);
            this.gridDisplay.method_46452((class_8021)button, i / this.gridSize, i % this.gridSize);
        }
    }

    protected void method_25426() {
        this.updateElements();
    }

    private void updateElements() {
        int gridWidth = 32 * this.gridSize + 5 * (this.gridSize - 1);
        int gridY = (int)((float)this.field_22790 * 0.2f);
        this.gridDisplay.method_48229(this.field_22789 / 2 - gridWidth / 2, gridY);
        this.gridDisplay.method_48222();
        this.buttonStates.keySet().forEach(button -> {
            if (!this.method_25396().contains(button)) {
                this.method_37063((class_364)button);
            }
        });
        this.confirm.method_48229(this.field_22789 / 2 - 40, gridY + gridWidth + 10);
        if (!this.method_25396().contains(this.confirm)) {
            this.method_37063((class_364)this.confirm);
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"captcha.ui.instruction"), this.field_22789 / 2, (int)((float)this.field_22790 * 0.05f), 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)this.captcha.get("text").getAsString()), this.field_22789 / 2, (int)((float)this.field_22790 * 0.1f), 16761633);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"captcha.ui.skip"), this.field_22789 / 2, (int)((float)this.field_22790 * 0.15f), 0xFFFFFF);
    }

    @Environment(value=EnvType.CLIENT)
    private class CaptchaImageButton
    extends class_4185 {
        private static final int outlineMargin = 2;
        private static final int outlineColor = -2130706433;
        private static final int selectedColor = -1;
        private final class_2960 image;

        protected CaptchaImageButton(int x, int y, int width, int height, class_2960 image, class_4185.class_4241 onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, MutableText -> class_2561.method_43471((String)"captcha.narrator.button"));
            this.image = image;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25290(this.image, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
            if (CaptchaScreen.this.buttonStates.getOrDefault((Object)this, false).booleanValue()) {
                context.method_49601(this.method_46426() - 2, this.method_46427() - 2, this.method_25368() + 4, this.method_25364() + 4, -2130706433);
            } else if (this.method_49606()) {
                context.method_49601(this.method_46426() - 2, this.method_46427() - 2, this.method_25368() + 4, this.method_25364() + 4, -1);
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.field_22763 && this.field_22764) {
                if (class_8494.method_51255((int)keyCode)) {
                    CaptchaScreen.this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)CaptchaSounds.sounds.get("button10"), (float)1.0f, (float)0.6f));
                    this.method_25306();
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

