/*
 * Decompiled with CFR 0.152.
 */
package net.tuples.captcha.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.tuples.captcha.client.CaptchaSounds;
import net.tuples.captcha.config.CaptchaData;

public class CaptchaScreen
extends class_437 {
    private final Map<CaptchaImageButton, Boolean> buttonStates = new LinkedHashMap<CaptchaImageButton, Boolean>();
    private final int cellSize = 32;
    private final int cellSpacing = 5;
    private int gridSize;
    private class_7845 gridDisplay;
    private final Map<String, Boolean> captchaKey = new LinkedHashMap<String, Boolean>();
    private JsonObject captcha_data;
    private String captchaId;
    private final class_310 client;
    private class_1144 soundManager;
    private class_1113 sound;
    private final class_4185 confirm = class_4185.method_46430((class_2561)class_2561.method_43471((String)"captcha.ui.button.confirm"), button -> {
        ArrayList<Boolean> correctValues = new ArrayList<Boolean>(this.captchaKey.values());
        boolean allMatch = true;
        int index = 0;
        for (Map.Entry<CaptchaImageButton, Boolean> entry : this.buttonStates.entrySet()) {
            if (entry.getValue() != correctValues.get(index)) {
                allMatch = false;
                break;
            }
            ++index;
        }
        if (allMatch) {
            this.soundManager.method_4873((class_1113)class_1109.method_25466((class_3414)CaptchaSounds.get("button3")));
            class_310.method_1551().method_1507(null);
        } else {
            this.soundManager.method_4873((class_1113)class_1109.method_25466((class_3414)CaptchaSounds.get("button10")));
            this.refreshCaptcha();
        }
    }).method_46437(80, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)":)"))).method_46431();

    public CaptchaScreen() {
        super((class_2561)class_2561.method_43471((String)"captcha.narrator.title"));
        this.client = class_310.method_1551();
        this.soundManager = this.client.method_1483();
        this.soundManager.method_4873((class_1113)class_1109.method_25466((class_3414)CaptchaSounds.get("blip1")));
        this.refreshCaptcha();
    }

    private void refreshCaptcha() {
        this.method_25396().removeIf(widget -> widget instanceof CaptchaImageButton);
        this.buttonStates.clear();
        this.gridDisplay = new class_7845().method_48637(5);
        ArrayList keys = new ArrayList(CaptchaData.captchas.keySet());
        if (this.captchaId != null) {
            keys.remove(this.captchaId);
        }
        int rand = new Random().nextInt(keys.size());
        this.captchaId = (String)keys.get(rand);
        this.captcha_data = CaptchaData.captchas.get(this.captchaId).getAsJsonObject();
        this.captchaKey.clear();
        for (Map.Entry entry : this.captcha_data.get("images").getAsJsonObject().entrySet()) {
            this.captchaKey.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
        }
        if (this.captcha_data.get("creep").getAsBoolean()) {
            if (this.client.field_1687 != null && this.client.field_1724 != null) {
                if (this.soundManager.method_4877(this.sound)) {
                    this.soundManager.method_4870(this.sound);
                }
                this.sound = class_1109.method_25466((class_3414)CaptchaSounds.randomWhisper());
                this.soundManager.method_4873(this.sound);
            }
        } else if (this.soundManager.method_4877(this.sound)) {
            this.soundManager.method_4870(this.sound);
        }
        this.initializeButtons();
        this.updateElements();
    }

    private void initializeButtons() {
        ArrayList<String> imagePaths = new ArrayList<String>(this.captchaKey.keySet());
        this.gridSize = (int)Math.ceil(Math.sqrt(imagePaths.size()));
        for (int i = 0; i < imagePaths.size(); ++i) {
            class_2960 image = class_2960.method_60655((String)"captcha", (String)((String)imagePaths.get(i)));
            CaptchaImageButton button = new CaptchaImageButton(0, 0, 32, 32, image, b -> this.buttonStates.put((CaptchaImageButton)b, this.buttonStates.getOrDefault(b, false) == false));
            this.buttonStates.put(button, false);
            this.gridDisplay.method_46452((class_8021)button, i / this.gridSize, i % this.gridSize);
        }
    }

    private void layoutGrid() {
        int index = 0;
        for (CaptchaImageButton button : this.buttonStates.keySet()) {
            int row = index / this.gridSize;
            int col = index % this.gridSize;
            int x = this.gridDisplay.method_46426() + col * 37;
            int y = this.gridDisplay.method_46427() + row * 37;
            button.method_48229(x, y);
            ++index;
        }
    }

    private void updateElements() {
        int gridWidth = 32 * this.gridSize + 5 * (this.gridSize - 1);
        int gridY = (int)((float)this.field_22790 * 0.2f);
        this.gridDisplay.method_48229(this.field_22789 / 2 - gridWidth / 2, gridY);
        this.layoutGrid();
        this.buttonStates.keySet().forEach(button -> {
            if (!this.method_25396().contains(button)) {
                this.method_37063((class_364)button);
            }
        });
        this.confirm.method_48229(this.field_22789 / 2 - 40, gridY + gridWidth + 10);
        if (!this.method_25396().contains(this.confirm)) {
            this.method_37063((class_364)this.confirm);
        }
    }

    private void renderText(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_27534(this.client.field_1772, (class_2561)class_2561.method_43471((String)"captcha.ui.instruction"), this.field_22789 / 2, (int)((float)this.field_22790 * 0.05f), -1);
        guiGraphics.method_27534(this.client.field_1772, (class_2561)class_2561.method_43471((String)this.captcha_data.get("text").getAsString()), this.field_22789 / 2, (int)((float)this.field_22790 * 0.1f), -15583);
    }

    protected void method_25426() {
        this.updateElements();
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.renderText(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }

    private class CaptchaImageButton
    extends class_4185 {
        private static final int outlineMargin = 2;
        private static final int outlineColor = -2130706433;
        private static final int selectedColor = -1;
        private final class_2960 image;

        protected CaptchaImageButton(int x, int y, int width, int height, class_2960 image, class_4185.class_4241 onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, MutableText -> class_2561.method_43471((String)"captcha.narrator.button"));
            this.image = image;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
            guiGraphics.method_70845(this.image, this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0.0f, 1.0f, 0.0f, 1.0f);
            if (CaptchaScreen.this.buttonStates.getOrDefault((Object)this, false).booleanValue()) {
                this.drawBorder(guiGraphics, this.method_46426() - 2, this.method_46427() - 2, this.method_25368() + 4, this.method_25364() + 4, -2130706433);
            } else if (this.method_49606()) {
                this.drawBorder(guiGraphics, this.method_46426() - 2, this.method_46427() - 2, this.method_25368() + 4, this.method_25364() + 4, -1);
            }
        }

        private void drawBorder(class_332 guiGraphics, int x, int y, int width, int height, int color) {
            guiGraphics.method_25294(x, y, x + width, y + 1, color);
            guiGraphics.method_25294(x, y + height - 1, x + width, y + height, color);
            guiGraphics.method_25294(x, y, x + 1, y + height, color);
            guiGraphics.method_25294(x + width - 1, y, x + width, y + height, color);
        }
    }
}

