/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import top.mcpo.ch.cHSSponsors.backup.BackupManager;
import top.mcpo.ch.cHSSponsors.commands.SponsorsCommand;
import top.mcpo.ch.cHSSponsors.commands.SponsorsTabCompleter;
import top.mcpo.ch.cHSSponsors.export.ExportManager;
import top.mcpo.ch.cHSSponsors.language.LanguageManager;
import top.mcpo.ch.cHSSponsors.notifications.NotificationManager;
import top.mcpo.ch.cHSSponsors.permissions.PermissionManager;
import top.mcpo.ch.cHSSponsors.placeholders.SponsorsExpansion;
import top.mcpo.ch.cHSSponsors.rewards.RewardManager;
import top.mcpo.ch.cHSSponsors.storage.MySQLStorage;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;
import top.mcpo.ch.cHSSponsors.storage.YamlStorage;

public final class CHSSponsors
extends JavaPlugin {
    private StorageInterface storage;
    private NotificationManager notificationManager;
    private ExportManager exportManager;
    private BackupManager backupManager;
    private PermissionManager permissionManager;
    private LanguageManager languageManager;
    private RewardManager rewardManager;

    private void printLogo(boolean isEnabled) {
        String color = isEnabled ? "\u00a7a" : "\u00a7c";
        this.getLogger().info("\n" + color + "   _____                                        \n" + color + "  / ___/____  ____  ____  _____  ____  _____\n" + color + "  \\__ \\/ __ \\/ __ \\/ __ \\/ ___/ / __ \\/ ___/\n" + color + " ___/ / /_/ / /_/ / / / (__  ) / /_/ / /    \n" + color + "/____/ .___/\\____/_/ /_/____/  \\____/_/     \n" + color + "     /_/                                        \n" + (isEnabled ? "\u00a7e\u8d5e\u52a9\u8005\u63d2\u4ef6\u5df2\u542f\u7528\uff01" : "\u00a7e\u8d5e\u52a9\u8005\u63d2\u4ef6\u5df2\u7981\u7528\uff01"));
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.languageManager = new LanguageManager(this);
        this.notificationManager = new NotificationManager(this);
        boolean enableMysql = this.getConfig().getBoolean("enable-mysql", false);
        if (enableMysql) {
            this.storage = new MySQLStorage(this);
            this.getLogger().info("\u4f7f\u7528MySQL\u6570\u636e\u5e93\u5b58\u50a8");
        } else {
            this.storage = new YamlStorage(this);
            this.getLogger().info("\u4f7f\u7528YAML\u6587\u4ef6\u5b58\u50a8");
        }
        this.storage.initialize();
        this.exportManager = new ExportManager(this, this.storage);
        this.backupManager = new BackupManager(this, this.storage);
        this.permissionManager = new PermissionManager(this);
        this.rewardManager = new RewardManager(this);
        this.getCommand("sponsors").setExecutor((CommandExecutor)new SponsorsCommand(this, this.storage, this.notificationManager, this.exportManager, this.languageManager));
        this.getCommand("sponsors").setTabCompleter((TabCompleter)new SponsorsTabCompleter());
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new SponsorsExpansion(this, this.storage).register();
            this.getLogger().info("PlaceholderAPI \u6269\u5c55\u5df2\u6ce8\u518c");
        }
        this.printLogo(true);
    }

    public void onDisable() {
        if (this.storage != null) {
            this.storage.close();
        }
        this.printLogo(false);
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        if (this.backupManager != null) {
            this.backupManager.reloadConfig();
        }
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }
}

