/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.backup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.model.SponsorshipRecord;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;

public class BackupManager {
    private final CHSSponsors plugin;
    private final StorageInterface storage;
    private final File backupDir;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private final boolean backupEnabled;
    private final long backupInterval;
    private final int keepDays;
    private BukkitRunnable backupTask;

    public BackupManager(CHSSponsors plugin, StorageInterface storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.backupDir = new File(plugin.getDataFolder(), "backups");
        if (!this.backupDir.exists()) {
            this.backupDir.mkdirs();
        }
        this.backupEnabled = plugin.getConfig().getBoolean("backup.enabled", true);
        int intervalHours = plugin.getConfig().getInt("backup.interval", 24);
        this.backupInterval = (long)(intervalHours * 60 * 60) * 20L;
        this.keepDays = plugin.getConfig().getInt("backup.keep-days", 7);
        if (this.backupEnabled) {
            this.startBackupTask();
        }
    }

    private void startBackupTask() {
        if (this.backupTask != null) {
            this.backupTask.cancel();
        }
        this.backupTask = new BukkitRunnable(){

            public void run() {
                BackupManager.this.createBackup();
            }
        };
        this.backupTask.runTaskTimer((Plugin)this.plugin, this.backupInterval, this.backupInterval);
        this.plugin.getLogger().info("\u81ea\u52a8\u5907\u4efd\u5df2\u542f\u7528\uff0c\u95f4\u9694: " + this.backupInterval / 72000L + "\u5c0f\u65f6");
    }

    public void stopBackupTask() {
        if (this.backupTask != null) {
            this.backupTask.cancel();
            this.backupTask = null;
        }
    }

    public void createBackup() {
        String timestamp = this.dateFormat.format(new Date());
        File backupFile = new File(this.backupDir, "backup_" + timestamp + ".zip");
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));){
            this.backupSponsorsData(zos);
            this.backupHistoryData(zos);
            this.plugin.getLogger().info("\u81ea\u52a8\u5907\u4efd\u5df2\u5b8c\u6210: " + backupFile.getName());
            this.cleanOldBackups();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u81ea\u52a8\u5907\u4efd\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void backupSponsorsData(ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry("sponsors.csv"));
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)zos, "UTF-8"));
        writer.println("\u73a9\u5bb6\u540d\u79f0,\u8d5e\u52a9\u603b\u989d");
        List<Map.Entry<String, Double>> sponsors = this.storage.getTopSponsors(Integer.MAX_VALUE);
        for (Map.Entry<String, Double> sponsor : sponsors) {
            writer.printf("%s,%.2f%n", sponsor.getKey(), sponsor.getValue());
        }
        writer.flush();
        zos.closeEntry();
    }

    private void backupHistoryData(ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry("history.csv"));
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)zos, "UTF-8"));
        writer.println("\u65f6\u95f4,\u73a9\u5bb6\u540d\u79f0,\u64cd\u4f5c\u7c7b\u578b,\u91d1\u989d,\u64cd\u4f5c\u8005");
        long endTime = System.currentTimeMillis();
        long startTime = 0L;
        List<SponsorshipRecord> history = this.storage.getHistory(null, startTime, endTime);
        SimpleDateFormat recordDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (SponsorshipRecord record : history) {
            writer.printf("%s,%s,%s,%.2f,%s%n", recordDateFormat.format(new Date(record.getTimestamp())), record.getPlayerName(), record.getOperationType(), record.getAmount(), record.getOperator());
        }
        writer.flush();
        zos.closeEntry();
    }

    private void cleanOldBackups() {
        if (this.keepDays <= 0) {
            return;
        }
        File[] backups = this.backupDir.listFiles((dir, name) -> name.startsWith("backup_") && name.endsWith(".zip"));
        if (backups == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long keepTime = (long)(this.keepDays * 24 * 60 * 60) * 1000L;
        for (File backup : backups) {
            if (now - backup.lastModified() <= keepTime) continue;
            if (!backup.delete()) {
                this.plugin.getLogger().warning("\u65e0\u6cd5\u5220\u9664\u65e7\u5907\u4efd\u6587\u4ef6: " + backup.getName());
                continue;
            }
            this.plugin.getLogger().info("\u5df2\u5220\u9664\u8fc7\u671f\u5907\u4efd: " + backup.getName());
        }
    }

    public void reloadConfig() {
        boolean newBackupEnabled = this.plugin.getConfig().getBoolean("backup.enabled", true);
        int newIntervalHours = this.plugin.getConfig().getInt("backup.interval", 24);
        long newBackupInterval = (long)(newIntervalHours * 60 * 60) * 20L;
        if (newBackupEnabled != this.backupEnabled || newBackupInterval != this.backupInterval) {
            this.stopBackupTask();
            if (newBackupEnabled) {
                this.startBackupTask();
            }
        }
    }
}

