/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.commands;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.export.ExportManager;
import top.mcpo.ch.cHSSponsors.language.LanguageManager;
import top.mcpo.ch.cHSSponsors.model.SponsorshipRecord;
import top.mcpo.ch.cHSSponsors.notifications.NotificationManager;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;

public class SponsorsCommand
implements CommandExecutor {
    private final CHSSponsors plugin;
    private final StorageInterface storage;
    private final NotificationManager notificationManager;
    private final ExportManager exportManager;
    private final LanguageManager languageManager;

    public SponsorsCommand(CHSSponsors plugin, StorageInterface storage, NotificationManager notificationManager, ExportManager exportManager, LanguageManager languageManager) {
        this.plugin = plugin;
        this.storage = storage;
        this.notificationManager = notificationManager;
        this.exportManager = exportManager;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String action;
        if (!sender.hasPermission("sponsors.use")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "add": {
                if (!sender.hasPermission("sponsors.add")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u6dfb\u52a0\u8d5e\u52a9\uff01");
                    return true;
                }
                this.handleMoneyOperation(sender, args);
                break;
            }
            case "removemoney": {
                if (!sender.hasPermission("sponsors.removemoney")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u51cf\u5c11\u8d5e\u52a9\uff01");
                    return true;
                }
                this.handleMoneyOperation(sender, args);
                break;
            }
            case "check": {
                if (!sender.hasPermission("sponsors.check")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8d5e\u52a9\u4fe1\u606f\uff01");
                    return true;
                }
                this.handleCheck(sender, args);
                break;
            }
            case "top": {
                if (!sender.hasPermission("sponsors.top")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u4f60\u6ca1\u6709\u6743\u9650\u67e5\u770b\u6392\u884c\u699c\uff01");
                    return true;
                }
                this.handleTop(sender);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "total": {
                this.handleTotal(sender);
                break;
            }
            case "history": {
                this.handleHistory(sender, args);
                break;
            }
            case "stats": {
                this.handleStats(sender, args);
                break;
            }
            case "export": {
                this.handleExport(sender, args);
                break;
            }
            case "backup": {
                this.handleBackup(sender);
                break;
            }
            case "language": {
                if (!sender.hasPermission("sponsors.admin")) {
                    sender.sendMessage(this.languageManager.getMessage("no-permission"));
                    return true;
                }
                if (args.length == 1) {
                    String currentLang = this.languageManager.getCurrentLanguage();
                    String availableLangs = String.join((CharSequence)", ", this.languageManager.getAvailableLanguages());
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("language", currentLang);
                    placeholders.put("languages", availableLangs);
                    sender.sendMessage(this.languageManager.formatMessage("language.current", placeholders));
                    sender.sendMessage(this.languageManager.formatMessage("language.available", placeholders));
                    return true;
                }
                if (args.length == 2) {
                    String newLang = args[1];
                    if (this.languageManager.setServerLanguage(newLang)) {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("language", newLang);
                        String message = this.languageManager.formatMessage("language.changed", placeholders);
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendMessage(message);
                        }
                    } else {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("language", newLang);
                        sender.sendMessage(this.languageManager.formatMessage("language.not-found", placeholders));
                    }
                    return true;
                }
                return false;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void handleCheck(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /sponsors check <\u73a9\u5bb6\u540d\u79f0>");
            return;
        }
        String playerName = args[1];
        double amount = this.storage.getSponsorship(playerName);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u73a9\u5bb6 " + playerName + " \u7684\u8d5e\u52a9\u603b\u989d\u4e3a: " + amount);
    }

    private void handleTop(CommandSender sender) {
        List<Map.Entry<String, Double>> top = this.storage.getTopSponsors(10);
        sender.sendMessage(this.languageManager.getMessage("top.header"));
        if (top.isEmpty()) {
            sender.sendMessage(this.languageManager.getMessage("top.empty"));
        } else {
            int rank = 1;
            for (Map.Entry<String, Double> entry : top) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("rank", String.valueOf(rank));
                placeholders.put("player", entry.getKey());
                placeholders.put("amount", String.valueOf(entry.getValue()));
                sender.sendMessage(this.languageManager.formatMessage("top.format", placeholders));
                ++rank;
            }
        }
        sender.sendMessage(this.languageManager.getMessage("top.footer"));
    }

    private void handleList(CommandSender sender) {
        List<String> sponsors = this.storage.getAllSponsors();
        sender.sendMessage(this.languageManager.getMessage("list.header"));
        if (sponsors.isEmpty()) {
            sender.sendMessage(this.languageManager.getMessage("list.empty"));
        } else {
            for (String sponsor : sponsors) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", sponsor);
                placeholders.put("amount", String.valueOf(this.storage.getSponsorship(sponsor)));
                sender.sendMessage(this.languageManager.formatMessage("list.format", placeholders));
            }
        }
        sender.sendMessage(this.languageManager.getMessage("list.footer"));
    }

    private void handleTotal(CommandSender sender) {
        double total = this.storage.getTotalSponsorship();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(total));
        sender.sendMessage(this.languageManager.formatMessage("total.message", placeholders));
    }

    private void handleHistory(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.languageManager.getMessage("invalid-usage"));
            return;
        }
        String playerName = args[1];
        int days = args.length > 2 ? Integer.parseInt(args[2]) : 7;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - (long)(days * 24 * 60 * 60) * 1000L;
        List<SponsorshipRecord> history = this.storage.getHistory(playerName, startTime, endTime);
        HashMap<String, String> headerPlaceholders = new HashMap<String, String>();
        headerPlaceholders.put("player", playerName);
        headerPlaceholders.put("days", String.valueOf(days));
        sender.sendMessage(this.languageManager.formatMessage("history.header", headerPlaceholders));
        if (history.isEmpty()) {
            sender.sendMessage(this.languageManager.getMessage("history.empty"));
        } else {
            for (SponsorshipRecord record : history) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("date", new Date(record.getTimestamp()).toString());
                String operationType = record.getOperationType().equals("ADD") ? this.languageManager.getMessage("operation.add") : this.languageManager.getMessage("operation.remove");
                placeholders.put("type", operationType);
                placeholders.put("amount", String.valueOf(record.getAmount()));
                placeholders.put("operator", record.getOperator());
                sender.sendMessage(this.languageManager.formatMessage("history.format", placeholders));
            }
        }
        sender.sendMessage(this.languageManager.getMessage("history.footer"));
    }

    private void handleStats(CommandSender sender, String[] args) {
        int days = args.length > 1 ? Integer.parseInt(args[1]) : 30;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - (long)(days * 24 * 60 * 60) * 1000L;
        double total = this.storage.getTotalBetween(startTime, endTime);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("days", String.valueOf(days));
        placeholders.put("amount", String.valueOf(total));
        sender.sendMessage(this.languageManager.formatMessage("stats.header", placeholders));
        sender.sendMessage(this.languageManager.formatMessage("stats.total", placeholders));
        sender.sendMessage(this.languageManager.getMessage("stats.footer"));
    }

    private void handleMoneyOperation(CommandSender sender, String[] args) {
        double amount;
        if (args.length < 3) {
            HashMap placeholders = new HashMap();
            sender.sendMessage(this.languageManager.getMessage("invalid-usage"));
            return;
        }
        String playerName = args[1];
        try {
            amount = Double.parseDouble(args[2]);
            if (amount <= 0.0) {
                sender.sendMessage(this.languageManager.getMessage("invalid-amount"));
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.languageManager.getMessage("invalid-amount"));
            return;
        }
        boolean isAdd = args[0].equalsIgnoreCase("add");
        if (isAdd) {
            this.storage.addSponsorship(playerName, amount, sender.getName());
        } else {
            this.storage.removeSponsorship(playerName, amount, sender.getName());
        }
        this.notificationManager.notifySponsorship(playerName, amount, isAdd);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", playerName);
        placeholders.put("amount", String.valueOf(amount));
        double currentAmount = this.storage.getSponsorship(playerName);
        placeholders.put("total", String.valueOf(currentAmount));
        if (isAdd) {
            sender.sendMessage(this.languageManager.formatMessage("add.success", placeholders));
        } else {
            sender.sendMessage(this.languageManager.formatMessage("remove.success", placeholders));
        }
    }

    private void handleExport(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /sponsors export <sponsors|history>");
            return;
        }
        String type = args[1].toLowerCase();
        if (!type.equals("sponsors") && !type.equals("history")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u5bfc\u51fa\u7c7b\u578b\u5fc5\u987b\u662f sponsors \u6216 history\uff01");
            return;
        }
        this.exportManager.exportToCSV(sender, type);
    }

    private void handleBackup(CommandSender sender) {
        this.exportManager.createBackup(sender);
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(this.languageManager.getMessage("help.header"));
        if (sender.hasPermission("sponsors.add")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.add"));
        }
        if (sender.hasPermission("sponsors.removemoney")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.removemoney"));
        }
        if (sender.hasPermission("sponsors.check")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.check"));
        }
        if (sender.hasPermission("sponsors.top")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.top"));
        }
        if (sender.hasPermission("sponsors.list")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.list"));
        }
        if (sender.hasPermission("sponsors.total")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.total"));
        }
        if (sender.hasPermission("sponsors.history")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.history"));
        }
        if (sender.hasPermission("sponsors.stats")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.stats"));
        }
        if (sender.hasPermission("sponsors.export")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.export"));
        }
        if (sender.hasPermission("sponsors.backup")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.backup"));
        }
        if (sender.hasPermission("sponsors.language")) {
            sender.sendMessage(this.languageManager.getMessage("help.commands.language"));
        }
    }
}

