/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import top.mcpo.ch.cHSSponsors.CHSSponsors;

public class SponsorsTabCompleter
implements TabCompleter {
    private final List<String> subCommands = Arrays.asList("add", "removemoney", "check", "top", "list", "total", "history", "stats", "export", "backup");

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!sender.hasPermission("sponsors.admin")) {
            return completions;
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            for (String subCommand : this.subCommands) {
                if (!subCommand.startsWith(input)) continue;
                completions.add(subCommand);
            }
            if (sender.hasPermission("sponsors.admin")) {
                completions.add("language");
            }
        } else if (args.length == 2) {
            String input = args[1].toLowerCase();
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            if (args[0].equalsIgnoreCase("language") && sender.hasPermission("sponsors.admin")) {
                CHSSponsors plugin = (CHSSponsors)CHSSponsors.getPlugin(CHSSponsors.class);
                completions.addAll(Arrays.asList(plugin.getLanguageManager().getAvailableLanguages()));
            }
        } else if (args.length == 3) {
            completions.addAll(Arrays.asList("10", "50", "100", "500", "1000"));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("export")) {
            String input = args[1].toLowerCase();
            List<String> exportTypes = Arrays.asList("sponsors", "history");
            return exportTypes.stream().filter(type -> type.startsWith(input)).collect(Collectors.toList());
        }
        return completions;
    }
}

