/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import top.mcpo.ch.cHSSponsors.CHSSponsors;

public class DatabaseManager {
    private final CHSSponsors plugin;
    private Connection connection;
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final String table;

    public DatabaseManager(CHSSponsors plugin) {
        this.plugin = plugin;
        this.host = plugin.getConfig().getString("mysql.host");
        this.port = plugin.getConfig().getInt("mysql.port");
        this.database = plugin.getConfig().getString("mysql.database");
        this.username = plugin.getConfig().getString("mysql.username");
        this.password = plugin.getConfig().getString("mysql.password");
        this.table = plugin.getConfig().getString("mysql.table");
        this.connect();
        this.createTable();
    }

    private void connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            String url = String.format("jdbc:mysql://%s:%d/%s", this.host, this.port, this.database);
            this.connection = DriverManager.getConnection(url, this.username, this.password);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTable() {
        try (Statement statement = this.connection.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS " + this.table + " (player_name VARCHAR(36) PRIMARY KEY,amount DECIMAL(10,2) NOT NULL DEFAULT 0.00)";
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addSponsorship(String playerName, double amount) {
        try {
            String sql = "INSERT INTO " + this.table + " (player_name, amount) VALUES (?, ?) ON DUPLICATE KEY UPDATE amount = amount + ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            statement.setDouble(2, amount);
            statement.setDouble(3, amount);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeSponsorship(String playerName, double amount) {
        try {
            String sql = "UPDATE " + this.table + " SET amount = GREATEST(0, amount - ?) WHERE player_name = ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setDouble(1, amount);
            statement.setString(2, playerName);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public double getSponsorship(String playerName) {
        try {
            String sql = "SELECT amount FROM " + this.table + " WHERE player_name = ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                return result.getDouble("amount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

