/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.model.SponsorshipRecord;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;

public class ExportManager {
    private final CHSSponsors plugin;
    private final StorageInterface storage;
    private final File exportDir;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    public ExportManager(CHSSponsors plugin, StorageInterface storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.exportDir = new File(plugin.getDataFolder(), "exports");
        if (!this.exportDir.exists()) {
            this.exportDir.mkdirs();
        }
    }

    public void exportToCSV(CommandSender sender, String type) {
        String timestamp = this.dateFormat.format(new Date());
        File file = new File(this.exportDir, type + "_" + timestamp + ".csv");
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            switch (type.toLowerCase()) {
                case "sponsors": {
                    this.exportSponsors(writer);
                    break;
                }
                case "history": {
                    this.exportHistory(writer);
                    break;
                }
                default: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "\u65e0\u6548\u7684\u5bfc\u51fa\u7c7b\u578b\uff01");
                    return;
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6570\u636e\u5df2\u5bfc\u51fa\u5230: " + file.getName());
        }
        catch (IOException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u5bfc\u51fa\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void exportSponsors(PrintWriter writer) {
        writer.println("\u73a9\u5bb6\u540d\u79f0,\u8d5e\u52a9\u603b\u989d");
        List<Map.Entry<String, Double>> sponsors = this.storage.getTopSponsors(Integer.MAX_VALUE);
        for (Map.Entry<String, Double> sponsor : sponsors) {
            writer.printf("%s,%.2f%n", sponsor.getKey(), sponsor.getValue());
        }
    }

    private void exportHistory(PrintWriter writer) {
        writer.println("\u65f6\u95f4,\u73a9\u5bb6\u540d\u79f0,\u64cd\u4f5c\u7c7b\u578b,\u91d1\u989d,\u64cd\u4f5c\u8005");
        long endTime = System.currentTimeMillis();
        long startTime = 0L;
        List<SponsorshipRecord> history = this.storage.getHistory(null, startTime, endTime);
        SimpleDateFormat recordDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (SponsorshipRecord record : history) {
            writer.printf("%s,%s,%s,%.2f,%s%n", recordDateFormat.format(new Date(record.getTimestamp())), record.getPlayerName(), record.getOperationType(), record.getAmount(), record.getOperator());
        }
    }

    public void createBackup(CommandSender sender) {
        String timestamp = this.dateFormat.format(new Date());
        File backupFile = new File(this.exportDir, "backup_" + timestamp + ".zip");
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));){
            this.addFileToZip(zos, new File(this.plugin.getDataFolder(), "config.yml"), "config.yml");
            this.addFileToZip(zos, new File(this.plugin.getDataFolder(), "sponsors.yml"), "sponsors.yml");
            File sponsorsCSV = this.exportToTempCSV("sponsors");
            File historyCSV = this.exportToTempCSV("history");
            this.addFileToZip(zos, sponsorsCSV, "data/sponsors.csv");
            this.addFileToZip(zos, historyCSV, "data/history.csv");
            sponsorsCSV.delete();
            historyCSV.delete();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u5907\u4efd\u5df2\u521b\u5efa: " + backupFile.getName());
        }
        catch (IOException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u5907\u4efd\u521b\u5efa\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private File exportToTempCSV(String type) throws IOException {
        File tempFile = File.createTempFile(type + "_temp", ".csv");
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));){
            if ("sponsors".equals(type)) {
                this.exportSponsors(writer);
            } else {
                this.exportHistory(writer);
            }
        }
        return tempFile;
    }

    private void addFileToZip(ZipOutputStream zos, File file, String entryName) throws IOException {
        if (!file.exists()) {
            return;
        }
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            zos.putNextEntry(new ZipEntry(entryName));
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
            zos.closeEntry();
        }
    }
}

