/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.language;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import top.mcpo.ch.cHSSponsors.CHSSponsors;

public class LanguageManager {
    private final CHSSponsors plugin;
    private final Map<String, FileConfiguration> languages;
    private String currentLanguage;

    public LanguageManager(CHSSponsors plugin) {
        this.plugin = plugin;
        this.languages = new HashMap<String, FileConfiguration>();
        this.currentLanguage = plugin.getConfig().getString("language.default", "zh_CN");
        this.loadLanguages();
    }

    private void loadLanguages() {
        File langDir = new File(this.plugin.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
            this.plugin.saveResource("lang/zh_CN.yml", false);
            this.plugin.saveResource("lang/en_US.yml", false);
            this.plugin.saveResource("lang/zh_TW.yml", false);
            this.plugin.saveResource("lang/ja_JP.yml", false);
            this.plugin.saveResource("lang/ko_KR.yml", false);
            this.plugin.saveResource("lang/ru_RU.yml", false);
            this.plugin.saveResource("lang/fr_FR.yml", false);
        }
        for (File file : langDir.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            String langCode = file.getName().replace(".yml", "");
            this.languages.put(langCode, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        }
    }

    public String getMessage(String key) {
        FileConfiguration lang = this.languages.get(this.currentLanguage);
        if (lang == null) {
            this.plugin.getLogger().warning("\u627e\u4e0d\u5230\u8bed\u8a00\u6587\u4ef6: " + this.currentLanguage + "\uff0c\u4f7f\u7528\u9ed8\u8ba4\u8bed\u8a00");
            lang = this.languages.get("zh_CN");
        }
        String message = lang.getString("messages." + key, "Message not found: " + key);
        return message.replace('&', '\u00a7');
    }

    public String formatMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return message.replace('&', '\u00a7');
    }

    public boolean setServerLanguage(String langCode) {
        if (!this.languages.containsKey(langCode)) {
            return false;
        }
        this.currentLanguage = langCode;
        this.plugin.getConfig().set("language.default", (Object)langCode);
        this.plugin.saveConfig();
        return true;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String[] getAvailableLanguages() {
        return this.languages.keySet().toArray(new String[0]);
    }
}

