/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.notifications;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.language.LanguageManager;

public class NotificationManager {
    private final CHSSponsors plugin;
    private final LanguageManager languageManager;
    private final boolean broadcastEnabled;
    private final String addFormat;
    private final String removeFormat;
    private final List<SpecialAmount> specialAmounts;

    public NotificationManager(CHSSponsors plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.broadcastEnabled = plugin.getConfig().getBoolean("notifications.broadcast-enabled", true);
        this.addFormat = plugin.getConfig().getString("notifications.formats.add", "&a\u73a9\u5bb6 &b%player% &a\u8d5e\u52a9\u4e86 &6%amount%&a\uff0c\u611f\u8c22\u652f\u6301\uff01");
        this.removeFormat = plugin.getConfig().getString("notifications.formats.remove", "&c\u7ba1\u7406\u5458\u51cf\u5c11\u4e86\u73a9\u5bb6 &b%player% &c\u7684\u8d5e\u52a9\u91d1\u989d &6%amount%");
        this.specialAmounts = this.loadSpecialAmounts();
    }

    private List<SpecialAmount> loadSpecialAmounts() {
        ArrayList<SpecialAmount> amounts = new ArrayList<SpecialAmount>();
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("notifications.special-amounts.thresholds");
        if (section != null) {
            for (Map.Entry entry : section.getValues(false).entrySet()) {
                ConfigurationSection threshold = section.getConfigurationSection((String)entry.getKey());
                if (threshold == null) continue;
                amounts.add(new SpecialAmount(threshold.getDouble("amount"), threshold.getString("message")));
            }
        }
        amounts.sort((a, b) -> Double.compare(b.amount, a.amount));
        return amounts;
    }

    public void notifySponsorship(String playerName, double amount, boolean isAdd) {
        if (!this.broadcastEnabled) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", playerName);
        placeholders.put("amount", String.valueOf(amount));
        String message = isAdd ? this.languageManager.formatMessage("add.broadcast", placeholders) : this.languageManager.formatMessage("remove.broadcast", placeholders);
        Bukkit.broadcastMessage((String)message);
    }

    private static class SpecialAmount {
        final double amount;
        final String message;

        SpecialAmount(double amount, String message) {
            this.amount = amount;
            this.message = message;
        }
    }
}

