/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.placeholders;

import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;

public class SponsorsExpansion
extends PlaceholderExpansion {
    private final CHSSponsors plugin;
    private final StorageInterface storage;

    public SponsorsExpansion(CHSSponsors plugin, StorageInterface storage) {
        this.plugin = plugin;
        this.storage = storage;
    }

    public String getIdentifier() {
        return "sponsors";
    }

    public String getAuthor() {
        return (String)this.plugin.getDescription().getAuthors().get(0);
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (params.equals("total")) {
            return String.format("%.2f", this.storage.getTotalSponsorship());
        }
        if (params.equals("amount")) {
            if (player == null) {
                return "0.00";
            }
            return String.format("%.2f", this.storage.getSponsorship(player.getName()));
        }
        if (params.equals("rank")) {
            if (player == null) {
                return "\u672a\u6392\u540d";
            }
            List<Map.Entry<String, Double>> topList = this.storage.getTopSponsors(Integer.MAX_VALUE);
            int rank = 1;
            for (Map.Entry<String, Double> entry : topList) {
                if (entry.getKey().equals(player.getName())) {
                    return String.valueOf(rank);
                }
                ++rank;
            }
            return "\u672a\u6392\u540d";
        }
        if (params.startsWith("top_name_")) {
            try {
                int rank = Integer.parseInt(params.substring(9));
                List<Map.Entry<String, Double>> topList = this.storage.getTopSponsors(rank);
                if (rank <= topList.size()) {
                    return topList.get(rank - 1).getKey();
                }
            }
            catch (NumberFormatException rank) {
                // empty catch block
            }
            return "\u65e0";
        }
        if (params.startsWith("top_amount_")) {
            try {
                int rank = Integer.parseInt(params.substring(11));
                List<Map.Entry<String, Double>> topList = this.storage.getTopSponsors(rank);
                if (rank <= topList.size()) {
                    return String.format("%.2f", topList.get(rank - 1).getValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return "0.00";
        }
        return null;
    }
}

