/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.rewards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import top.mcpo.ch.cHSSponsors.CHSSponsors;

public class RewardManager {
    private final CHSSponsors plugin;
    private FileConfiguration config;
    private final File configFile;

    public RewardManager(CHSSponsors plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "rewards.yml");
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource("rewards.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public void givePackage(Player player, String packageId) {
        String path = "packages." + packageId;
        if (!this.config.contains(path) || !this.config.getBoolean(path + ".enabled", false)) {
            return;
        }
        List commands = this.config.getStringList(path + ".rewards.commands");
        for (String command : commands) {
            command = command.replace("%player%", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        List messages = this.config.getStringList(path + ".rewards.messages");
        for (String message : messages) {
            player.sendMessage(message.replace('&', '\u00a7'));
        }
    }

    public void checkTotalRewards(Player player, double amount) {
        if (!this.config.contains("total_rewards") || !this.config.getBoolean("total_rewards.enabled", false)) {
            return;
        }
        for (String key : this.config.getConfigurationSection("total_rewards.rewards").getKeys(false)) {
            double requirement;
            String path = "total_rewards.rewards." + key;
            if (!this.config.getBoolean(path + ".enabled", false) || !(amount >= (requirement = Double.parseDouble(key)))) continue;
            List commands = this.config.getStringList(path + ".commands");
            for (String command : commands) {
                command = command.replace("%player%", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
            List messages = this.config.getStringList(path + ".messages");
            for (String message : messages) {
                player.sendMessage(message.replace('&', '\u00a7'));
            }
        }
    }

    public void giveFirstDonationReward(Player player) {
        if (!this.config.getBoolean("first_donation.enabled", false)) {
            return;
        }
        List commands = this.config.getStringList("first_donation.rewards.commands");
        for (String command : commands) {
            command = command.replace("%player%", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        List messages = this.config.getStringList("first_donation.rewards.messages");
        for (String message : messages) {
            player.sendMessage(message.replace('&', '\u00a7'));
        }
    }

    public double getPackagePrice(String packageId) {
        return this.config.getDouble("packages." + packageId + ".price", 0.0);
    }

    public List<String> getPackageDescription(String packageId) {
        return this.config.getStringList("packages." + packageId + ".description");
    }

    public String getPackageName(String packageId) {
        return this.config.getString("packages." + packageId + ".name", packageId);
    }

    public boolean isPackageEnabled(String packageId) {
        String path = "packages." + packageId;
        return this.config.contains(path) && this.config.getBoolean(path + ".enabled", false);
    }

    public List<String> getEnabledPackages() {
        ArrayList<String> enabledPackages = new ArrayList<String>();
        if (this.config.contains("packages")) {
            for (String packageId : this.config.getConfigurationSection("packages").getKeys(false)) {
                if (!this.isPackageEnabled(packageId)) continue;
                enabledPackages.add(packageId);
            }
        }
        return enabledPackages;
    }
}

