/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.model.SponsorshipRecord;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;

public class MySQLStorage
implements StorageInterface {
    private final CHSSponsors plugin;
    private Connection connection;
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final String table;

    public MySQLStorage(CHSSponsors plugin) {
        this.plugin = plugin;
        this.host = plugin.getConfig().getString("mysql.host", "localhost");
        this.port = plugin.getConfig().getInt("mysql.port", 3306);
        this.database = plugin.getConfig().getString("mysql.database", "chs-sponsors");
        this.username = plugin.getConfig().getString("mysql.username", "root");
        this.password = plugin.getConfig().getString("mysql.password", "");
        this.table = plugin.getConfig().getString("mysql.table", "sponsors_data");
    }

    @Override
    public void initialize() {
        this.connect();
        this.createTable();
    }

    private void connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            String url = String.format("jdbc:mysql://%s:%d/%s", this.host, this.port, this.database);
            this.connection = DriverManager.getConnection(url, this.username, this.password);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTable() {
        try (Statement statement = this.connection.createStatement();){
            String sponsorsTable = "CREATE TABLE IF NOT EXISTS " + this.table + " (player_name VARCHAR(36) PRIMARY KEY,amount DECIMAL(10,2) NOT NULL DEFAULT 0.00)";
            statement.executeUpdate(sponsorsTable);
            String historyTable = "CREATE TABLE IF NOT EXISTS " + this.table + "_history (id INT AUTO_INCREMENT PRIMARY KEY,player_name VARCHAR(36) NOT NULL,amount DECIMAL(10,2) NOT NULL,operation_type ENUM('ADD', 'REMOVE') NOT NULL,operator VARCHAR(36),timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,FOREIGN KEY (player_name) REFERENCES " + this.table + "(player_name))";
            statement.executeUpdate(historyTable);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSponsorship(String playerName, double amount, String operator) {
        try {
            this.connection.setAutoCommit(false);
            String sql = "INSERT INTO " + this.table + " (player_name, amount) VALUES (?, ?) ON DUPLICATE KEY UPDATE amount = amount + ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            statement.setDouble(2, amount);
            statement.setDouble(3, amount);
            statement.executeUpdate();
            sql = "INSERT INTO " + this.table + "_history (player_name, amount, operation_type, operator) VALUES (?, ?, 'ADD', ?)";
            statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            statement.setDouble(2, amount);
            statement.setString(3, operator);
            statement.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSponsorship(String playerName, double amount, String operator) {
        try {
            this.connection.setAutoCommit(false);
            String sql = "UPDATE " + this.table + " SET amount = GREATEST(0, amount - ?) WHERE player_name = ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setDouble(1, amount);
            statement.setString(2, playerName);
            statement.executeUpdate();
            sql = "INSERT INTO " + this.table + "_history (player_name, amount, operation_type, operator) VALUES (?, ?, 'REMOVE', ?)";
            statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            statement.setDouble(2, amount);
            statement.setString(3, operator);
            statement.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addSponsorship(String playerName, double amount) {
        this.addSponsorship(playerName, amount, "CONSOLE");
    }

    @Override
    public void removeSponsorship(String playerName, double amount) {
        this.removeSponsorship(playerName, amount, "CONSOLE");
    }

    @Override
    public double getSponsorship(String playerName) {
        try {
            String sql = "SELECT amount FROM " + this.table + " WHERE player_name = ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                return result.getDouble("amount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Override
    public List<SponsorshipRecord> getHistory(String playerName, long startTime, long endTime) {
        ArrayList<SponsorshipRecord> history = new ArrayList<SponsorshipRecord>();
        try {
            String sql = "SELECT * FROM " + this.table + "_history WHERE player_name = ? AND timestamp BETWEEN FROM_UNIXTIME(?) AND FROM_UNIXTIME(?) ORDER BY timestamp DESC";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setString(1, playerName);
            statement.setLong(2, startTime / 1000L);
            statement.setLong(3, endTime / 1000L);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                history.add(new SponsorshipRecord(rs.getString("player_name"), rs.getDouble("amount"), rs.getString("operation_type"), rs.getString("operator"), rs.getTimestamp("timestamp").getTime()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return history;
    }

    @Override
    public double getTotalBetween(long startTime, long endTime) {
        try {
            String sql = "SELECT SUM(CASE WHEN operation_type = 'ADD' THEN amount ELSE -amount END) FROM " + this.table + "_history WHERE timestamp BETWEEN FROM_UNIXTIME(?) AND FROM_UNIXTIME(?)";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setLong(1, startTime / 1000L);
            statement.setLong(2, endTime / 1000L);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                return rs.getDouble(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Override
    public List<Map.Entry<String, Double>> getTopSponsors(int limit) {
        ArrayList<Map.Entry<String, Double>> topList = new ArrayList<Map.Entry<String, Double>>();
        try {
            String sql = "SELECT player_name, amount FROM " + this.table + " ORDER BY amount DESC LIMIT ?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setInt(1, limit);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                topList.add(new AbstractMap.SimpleEntry<String, Double>(rs.getString("player_name"), rs.getDouble("amount")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return topList;
    }

    @Override
    public List<String> getAllSponsors() {
        ArrayList<String> sponsors = new ArrayList<String>();
        try {
            String sql = "SELECT player_name FROM " + this.table + " WHERE amount > 0";
            Statement statement = this.connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                sponsors.add(rs.getString("player_name"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sponsors;
    }

    @Override
    public double getTotalSponsorship() {
        try {
            String sql = "SELECT SUM(amount) FROM " + this.table;
            Statement statement = this.connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                return rs.getDouble(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

