/*
 * Decompiled with CFR 0.152.
 */
package top.mcpo.ch.cHSSponsors.storage;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import top.mcpo.ch.cHSSponsors.CHSSponsors;
import top.mcpo.ch.cHSSponsors.model.SponsorshipRecord;
import top.mcpo.ch.cHSSponsors.storage.StorageInterface;

public class YamlStorage
implements StorageInterface {
    private final CHSSponsors plugin;
    private File sponsorsFile;
    private FileConfiguration sponsorsConfig;

    public YamlStorage(CHSSponsors plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.sponsorsFile = new File(this.plugin.getDataFolder(), "sponsors.yml");
        if (!this.sponsorsFile.exists()) {
            this.plugin.saveResource("sponsors.yml", false);
        }
        this.sponsorsConfig = YamlConfiguration.loadConfiguration((File)this.sponsorsFile);
    }

    @Override
    public void close() {
        try {
            this.sponsorsConfig.save(this.sponsorsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u4fdd\u5b58sponsors.yml\u6587\u4ef6\uff01");
            e.printStackTrace();
        }
    }

    @Override
    public void addSponsorship(String playerName, double amount) {
        double currentAmount = this.getSponsorship(playerName);
        this.sponsorsConfig.set("sponsors." + playerName, (Object)(currentAmount + amount));
        this.saveConfig();
    }

    @Override
    public void removeSponsorship(String playerName, double amount) {
        double currentAmount = this.getSponsorship(playerName);
        double newAmount = Math.max(0.0, currentAmount - amount);
        this.sponsorsConfig.set("sponsors." + playerName, (Object)newAmount);
        this.saveConfig();
    }

    @Override
    public double getSponsorship(String playerName) {
        return this.sponsorsConfig.getDouble("sponsors." + playerName, 0.0);
    }

    @Override
    public List<SponsorshipRecord> getHistory(String playerName, long startTime, long endTime) {
        ArrayList<SponsorshipRecord> history = new ArrayList<SponsorshipRecord>();
        if (!this.sponsorsConfig.contains("history")) {
            return history;
        }
        List historyList = this.sponsorsConfig.getMapList("history");
        for (Map record : historyList) {
            long timestamp;
            String recordPlayerName = (String)record.get("player_name");
            if (playerName != null && !playerName.equals(recordPlayerName) || (timestamp = ((Number)record.get("timestamp")).longValue()) < startTime || timestamp > endTime) continue;
            history.add(new SponsorshipRecord(recordPlayerName, ((Number)record.get("amount")).doubleValue(), (String)record.get("operation_type"), (String)record.get("operator"), timestamp));
        }
        return history;
    }

    @Override
    public double getTotalBetween(long startTime, long endTime) {
        double total = 0.0;
        if (!this.sponsorsConfig.contains("history")) {
            return total;
        }
        List historyList = this.sponsorsConfig.getMapList("history");
        for (Map record : historyList) {
            long timestamp = ((Number)record.get("timestamp")).longValue();
            if (timestamp < startTime || timestamp > endTime) continue;
            String operationType = (String)record.get("operation_type");
            double amount = ((Number)record.get("amount")).doubleValue();
            if ("ADD".equals(operationType)) {
                total += amount;
                continue;
            }
            if (!"REMOVE".equals(operationType)) continue;
            total -= amount;
        }
        return total;
    }

    @Override
    public void addSponsorship(String playerName, double amount, String operator) {
        this.addSponsorship(playerName, amount);
        List<HashMap<String, Object>> history = new ArrayList();
        if (this.sponsorsConfig.contains("history")) {
            history = this.sponsorsConfig.getList("history");
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("player_name", playerName);
        record.put("amount", amount);
        record.put("operation_type", "ADD");
        record.put("operator", operator);
        record.put("timestamp", System.currentTimeMillis());
        history.add(record);
        this.sponsorsConfig.set("history", history);
        this.saveConfig();
    }

    @Override
    public void removeSponsorship(String playerName, double amount, String operator) {
        this.removeSponsorship(playerName, amount);
        List<HashMap<String, Object>> history = new ArrayList();
        if (this.sponsorsConfig.contains("history")) {
            history = this.sponsorsConfig.getList("history");
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("player_name", playerName);
        record.put("amount", amount);
        record.put("operation_type", "REMOVE");
        record.put("operator", operator);
        record.put("timestamp", System.currentTimeMillis());
        history.add(record);
        this.sponsorsConfig.set("history", history);
        this.saveConfig();
    }

    @Override
    public double getTotalSponsorship() {
        double total = 0.0;
        if (!this.sponsorsConfig.contains("sponsors")) {
            return total;
        }
        for (String playerName : this.sponsorsConfig.getConfigurationSection("sponsors").getKeys(false)) {
            total += this.sponsorsConfig.getDouble("sponsors." + playerName, 0.0);
        }
        return total;
    }

    @Override
    public List<Map.Entry<String, Double>> getTopSponsors(int limit) {
        ArrayList<Map.Entry<String, Double>> topList = new ArrayList<Map.Entry<String, Double>>();
        if (!this.sponsorsConfig.contains("sponsors")) {
            return topList;
        }
        for (String playerName : this.sponsorsConfig.getConfigurationSection("sponsors").getKeys(false)) {
            double amount = this.sponsorsConfig.getDouble("sponsors." + playerName, 0.0);
            if (!(amount > 0.0)) continue;
            topList.add(new AbstractMap.SimpleEntry<String, Double>(playerName, amount));
        }
        topList.sort((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue()));
        if (limit > 0 && limit < topList.size()) {
            return topList.subList(0, limit);
        }
        return topList;
    }

    @Override
    public List<String> getAllSponsors() {
        ArrayList<String> sponsors = new ArrayList<String>();
        if (!this.sponsorsConfig.contains("sponsors")) {
            return sponsors;
        }
        for (String playerName : this.sponsorsConfig.getConfigurationSection("sponsors").getKeys(false)) {
            if (!(this.sponsorsConfig.getDouble("sponsors." + playerName, 0.0) > 0.0)) continue;
            sponsors.add(playerName);
        }
        return sponsors;
    }

    private void saveConfig() {
        try {
            this.sponsorsConfig.save(this.sponsorsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u4fdd\u5b58sponsors.yml\u6587\u4ef6\uff01");
            e.printStackTrace();
        }
    }
}

