/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.commands;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.models.PlayerState;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.task.TaskDefinition;
import com.example.speedrunnerswap.task.TaskDifficulty;
import com.example.speedrunnerswap.task.TaskManagerMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SwapCommand
implements CommandExecutor,
TabCompleter {
    private final SpeedrunnerSwap plugin;

    public SwapCommand(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    private boolean handleInterval(CommandSender sender, String[] rest) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        if (rest.length < 1) {
            sender.sendMessage("\u00a7cUsage: /swap interval <seconds>");
            return false;
        }
        try {
            int sec = Integer.parseInt(rest[0]);
            this.plugin.getConfigManager().setSwapInterval(sec);
            this.plugin.getGameManager().refreshSwapSchedule();
            sender.sendMessage("\u00a7aSwap interval set to \u00a7f" + this.plugin.getConfigManager().getSwapInterval() + "s");
            return true;
        }
        catch (NumberFormatException nfe) {
            sender.sendMessage("\u00a7cInvalid number: " + rest[0]);
            return false;
        }
    }

    private boolean handleRandomize(CommandSender sender, String[] rest) {
        boolean val;
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        if (rest.length < 1) {
            sender.sendMessage("\u00a7cUsage: /swap randomize <on|off>");
            return false;
        }
        String opt = rest[0].toLowerCase();
        boolean bl = val = opt.startsWith("on") || opt.equals("true");
        if (!(opt.equals("on") || opt.equals("off") || opt.equals("true") || opt.equals("false"))) {
            sender.sendMessage("\u00a7cUsage: /swap randomize <on|off>");
            return false;
        }
        this.plugin.getConfigManager().setSwapRandomized(val);
        this.plugin.getGameManager().refreshSwapSchedule();
        sender.sendMessage("\u00a7eRandomized swaps: " + (val ? "\u00a7aON" : "\u00a7cOFF"));
        return true;
    }

    private boolean handleHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7lSpeedrunnerSwap Help");
        sender.sendMessage("\u00a7e/swap gui \u00a77Open menu");
        sender.sendMessage("\u00a7e/swap start|stop|pause|resume \u00a77Control game");
        sender.sendMessage("\u00a7e/swap interval <seconds> \u00a77Set base swap interval");
        sender.sendMessage("\u00a7e/swap randomize <on|off> \u00a77Toggle randomized swaps");
        sender.sendMessage("\u00a7e/swap mode <dream|sapnap|task> \u00a77Set mode");
        sender.sendMessage("\u00a7e/swap tasks list \u00a77List tasks with difficulty + enabled");
        sender.sendMessage("\u00a7e/swap tasks enable|disable <id> \u00a77Toggle a task");
        sender.sendMessage("\u00a7e/swap tasks difficulty <easy|medium|hard> \u00a77Set difficulty pool");
        sender.sendMessage("\u00a7e/swap tasks reload \u00a77Reload tasks.yml");
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            String subCommand;
            if (args.length == 0) {
                return this.handleMainCommand(sender);
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "start": {
                    return this.handleStart(sender);
                }
                case "stop": {
                    return this.handleStop(sender);
                }
                case "pause": {
                    return this.handlePause(sender);
                }
                case "resume": {
                    return this.handleResume(sender);
                }
                case "status": {
                    return this.handleStatus(sender);
                }
                case "creator": {
                    return this.handleCreator(sender);
                }
                case "setrunners": {
                    return this.handleSetRunners(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "sethunters": {
                    return this.handleSetHunters(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "reload": {
                    return this.handleReload(sender);
                }
                case "gui": {
                    return this.handleMainCommand(sender);
                }
                case "mode": {
                    return this.handleMode(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "clearteams": {
                    return this.handleClearTeams(sender);
                }
                case "tasks": {
                    return this.handleTasks(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "complete": {
                    return this.handleTaskComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "interval": {
                    return this.handleInterval(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "randomize": {
                    return this.handleRandomize(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "help": {
                    return this.handleHelp(sender);
                }
            }
            sender.sendMessage("\u00a7cUnknown subcommand. Use /swap for help.");
            return false;
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cAn internal error occurred while executing that command. Check server logs for details.");
            this.plugin.getLogger().log(Level.SEVERE, "Unhandled exception while executing /swap by " + (sender == null ? "UNKNOWN" : sender.getName()), e);
            return false;
        }
    }

    private boolean handleMode(CommandSender sender, String[] rest) {
        SpeedrunnerSwap.SwapMode target;
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to change mode.");
            return false;
        }
        if (rest.length == 0) {
            sender.sendMessage("\u00a7eCurrent mode: \u00a7f" + this.plugin.getCurrentMode().name().toLowerCase());
            sender.sendMessage("\u00a77Usage: /swap mode <dream|sapnap|task> [--force]");
            return true;
        }
        boolean force = false;
        String targetArg = null;
        String[] stringArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if ("--force".equalsIgnoreCase(token) || "-f".equalsIgnoreCase(token) || "force".equalsIgnoreCase(token)) {
                force = true;
            } else if (targetArg == null) {
                targetArg = token;
            }
            ++n2;
        }
        if (targetArg == null) {
            sender.sendMessage("\u00a7cSpecify a mode to switch to (dream, sapnap, task).");
            return false;
        }
        String mode = targetArg.toLowerCase(Locale.ROOT);
        if ("default".equals(mode)) {
            sender.sendMessage("\u00a7eSetting a startup default is now handled in config.yml (game.default_mode).");
            return true;
        }
        switch (mode) {
            case "dream": 
            case "manhunt": 
            case "hunters": {
                SpeedrunnerSwap.SwapMode swapMode = SpeedrunnerSwap.SwapMode.DREAM;
                break;
            }
            case "sapnap": 
            case "multi": 
            case "multirunner": 
            case "control": 
            case "runners": {
                SpeedrunnerSwap.SwapMode swapMode = SpeedrunnerSwap.SwapMode.SAPNAP;
                break;
            }
            case "task": 
            case "task-manager": 
            case "taskmanager": 
            case "taskmaster": {
                SpeedrunnerSwap.SwapMode swapMode = SpeedrunnerSwap.SwapMode.TASK;
                break;
            }
            default: {
                SpeedrunnerSwap.SwapMode swapMode = target = null;
            }
        }
        if (target == null) {
            sender.sendMessage("\u00a7cUnknown mode: " + mode + ". Use dream|sapnap|task.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning() && !force) {
            sender.sendMessage("\u00a7cStop the current game before switching modes. Add --force to end it and switch now.");
            return false;
        }
        if (force && this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        this.plugin.setCurrentMode(target);
        String confirmation = switch (target) {
            case SpeedrunnerSwap.SwapMode.DREAM -> "\u00a7aMode set to \u00a7fDream\u00a7a (runners + hunters).";
            case SpeedrunnerSwap.SwapMode.SAPNAP -> "\u00a7aMode set to \u00a7fSapnap\u00a7a (multi-runner control).";
            case SpeedrunnerSwap.SwapMode.TASK -> "\u00a7aMode set to \u00a76Task Master\u00a7a (secret objectives).";
            default -> throw new IncompatibleClassChangeError();
        };
        sender.sendMessage(confirmation);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.plugin.getGuiManager().openMainMenu(player);
        }
        return true;
    }

    private boolean handleCreator(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7lSpeedrunner Swap");
        sender.sendMessage("\u00a7eCreated by \u00a7f m u j 3 b");
        sender.sendMessage("\u00a7d\u2764 Donate to support development");
        sender.sendMessage("\u00a7bhttps://donate.stripe.com/8x29AT0H58K03judnR0Ba01");
        return true;
    }

    private boolean handleMainCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return false;
        }
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGuiManager() == null) {
            sender.sendMessage("\u00a7cError: GUI Manager not initialized properly. Please report this to the plugin developer.");
            this.plugin.getLogger().log(Level.SEVERE, "GUI Manager is null when trying to open main menu");
            return false;
        }
        try {
            this.plugin.getGuiManager().openDirectGamemodeSelector((Player)sender);
            return true;
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cError opening GUI: " + e.getMessage());
            this.plugin.getLogger().log(Level.SEVERE, "Error opening GUI for player " + sender.getName(), e);
            return false;
        }
    }

    private boolean handleStart(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is already running.");
            return false;
        }
        boolean success = this.plugin.getGameManager().startGame();
        if (success) {
            sender.sendMessage("\u00a7aGame started successfully.");
        } else {
            SpeedrunnerSwap.SwapMode mode = this.plugin.getCurrentMode();
            if (mode == SpeedrunnerSwap.SwapMode.DREAM) {
                sender.sendMessage("\u00a7cFailed to start. Dream mode requires at least \u00a7e1 runner\u00a7c and \u00a7e1 hunter\u00a7c.");
            } else {
                sender.sendMessage("\u00a7cFailed to start. You must set at least \u00a7e1 runner\u00a7c.");
            }
        }
        return success;
    }

    private boolean handleStop(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is not running.");
            return false;
        }
        this.plugin.getGameManager().stopGame();
        sender.sendMessage("\u00a7aGame stopped.");
        return true;
    }

    private boolean handlePause(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        this.plugin.getGameManager().pauseGame();
        sender.sendMessage("\u00a7eGame paused.");
        return true;
    }

    private boolean handleResume(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        this.plugin.getGameManager().resumeGame();
        sender.sendMessage("\u00a7aGame resumed.");
        return true;
    }

    private boolean handleStatus(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        sender.sendMessage("\u00a76=== SpeedrunnerSwap Status ===");
        sender.sendMessage("\u00a7eGame Running: \u00a7f" + this.plugin.getGameManager().isGameRunning());
        sender.sendMessage("\u00a7eGame Paused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
        if (this.plugin.getGameManager().isGameRunning()) {
            Player activeRunner = this.plugin.getGameManager().getActiveRunner();
            sender.sendMessage("\u00a7eActive Runner: \u00a7f" + (activeRunner != null ? activeRunner.getName() : "None"));
            sender.sendMessage("\u00a7eTime Until Next Swap: \u00a7f" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            List<Player> runners = this.plugin.getGameManager().getRunners();
            List<Player> hunters = this.plugin.getGameManager().getHunters();
            sender.sendMessage("\u00a7eRunners: \u00a7f" + runners.stream().map(Player::getName).collect(Collectors.joining(", ")));
            sender.sendMessage("\u00a7eHunters: \u00a7f" + hunters.stream().map(Player::getName).collect(Collectors.joining(", ")));
        }
        return true;
    }

    private boolean handleSetRunners(CommandSender sender, String[] playerNames) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (playerNames.length == 0) {
            sender.sendMessage("\u00a7cUsage: /swap setrunners <player1> [player2] [player3] ...");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        String[] stringArray = playerNames;
        int n = playerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                players.add(player);
            } else {
                sender.sendMessage("\u00a7cPlayer not found: " + name);
            }
            ++n2;
        }
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo valid players specified.");
            return false;
        }
        this.plugin.getGameManager().setRunners(players);
        sender.sendMessage("\u00a7aRunners set: " + players.stream().map(Player::getName).collect(Collectors.joining(", ")));
        return true;
    }

    private boolean handleSetHunters(CommandSender sender, String[] playerNames) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (playerNames.length == 0) {
            sender.sendMessage("\u00a7cUsage: /swap sethunters <player1> [player2] [player3] ...");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        String[] stringArray = playerNames;
        int n = playerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                players.add(player);
            } else {
                sender.sendMessage("\u00a7cPlayer not found: " + name);
            }
            ++n2;
        }
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo valid players specified.");
            return false;
        }
        this.plugin.getGameManager().setHunters(players);
        sender.sendMessage("\u00a7aHunters set: " + players.stream().map(Player::getName).collect(Collectors.joining(", ")));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        this.plugin.getConfigManager().loadConfig();
        sender.sendMessage("\u00a7aConfiguration reloaded.");
        return true;
    }

    private boolean handleTasks(CommandSender sender, String[] rest) {
        String sub;
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to manage tasks.");
            return false;
        }
        if (rest.length == 0) {
            sender.sendMessage("\u00a7eUsage: /swap tasks <list|enable <id>|disable <id>|difficulty <easy|medium|hard>|reload|reroll|endwhenoneleft <on|off|toggle>>");
            return true;
        }
        switch (sub = rest[0].toLowerCase()) {
            case "list": {
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                Map<String, TaskDefinition> defs = tmm.getAllDefinitions();
                if (defs.isEmpty()) {
                    sender.sendMessage("\u00a77No tasks defined.");
                    return true;
                }
                sender.sendMessage("\u00a76Tasks (id \u00a77|\u00a7f difficulty \u00a77|\u00a7f enabled):");
                int shown = 0;
                for (Map.Entry<String, TaskDefinition> e : defs.entrySet()) {
                    TaskDefinition d = e.getValue();
                    sender.sendMessage("\u00a7e" + d.id() + " \u00a77| \u00a7f" + (d.difficulty() != null ? d.difficulty().name() : "MEDIUM") + " \u00a77| \u00a7f" + (d.enabled() ? "true" : "false"));
                    if (++shown < 50) continue;
                    sender.sendMessage("\u00a77\u2026 (showing first 50)");
                    break;
                }
                sender.sendMessage("\u00a77Difficulty filter: \u00a7f" + tmm.getDifficultyFilter().name() + "\u00a77 | Eligible now: \u00a7a" + tmm.getCandidateCount());
                return true;
            }
            case "enable": 
            case "disable": {
                if (rest.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /swap tasks " + sub + " <id>");
                    return false;
                }
                String id = rest[1];
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                boolean ok = tmm.setTaskEnabled(id, sub.equals("enable"));
                if (!ok) {
                    sender.sendMessage("\u00a7cUnknown task id: " + id);
                    return false;
                }
                sender.sendMessage("\u00a7aTask '" + id + "' " + (sub.equals("enable") ? "enabled" : "disabled") + ".");
                return true;
            }
            case "difficulty": {
                String lvl;
                if (rest.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /swap tasks difficulty <easy|medium|hard>");
                    return false;
                }
                TaskDifficulty d = switch (lvl = rest[1].toLowerCase()) {
                    case "easy" -> TaskDifficulty.EASY;
                    case "hard" -> TaskDifficulty.HARD;
                    default -> TaskDifficulty.MEDIUM;
                };
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                tmm.setDifficultyFilter(d);
                sender.sendMessage("\u00a7aTask difficulty filter set to \u00a7f" + d.name());
                return true;
            }
            case "reroll": {
                if (this.plugin.getGameManager().isGameRunning()) {
                    sender.sendMessage("\u00a7cYou can only reroll before the game starts.");
                    return false;
                }
                if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.TASK) {
                    sender.sendMessage("\u00a7cSwitch to Task Manager mode first: /swap mode task");
                    return false;
                }
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                ArrayList<Player> selectedRunners = new ArrayList<Player>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    PlayerState st = this.plugin.getGameManager().getPlayerState(p);
                    if (st == null || st.getSelectedTeam() != Team.RUNNER) continue;
                    selectedRunners.add(p);
                }
                if (selectedRunners.isEmpty()) {
                    sender.sendMessage("\u00a7cNo selected runners found. Use the Team Selector first.");
                    return false;
                }
                tmm.assignAndAnnounceTasks(selectedRunners);
                sender.sendMessage("\u00a7aRerolled tasks for \u00a7f" + selectedRunners.size() + "\u00a7a selected runners.");
                return true;
            }
            case "endwhenoneleft": {
                String opt;
                boolean cur = this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false);
                cur = rest.length >= 2 ? ((opt = rest[1].toLowerCase()).equals("on") || opt.equals("true") ? true : (opt.equals("off") || opt.equals("false") ? false : !cur)) : !cur;
                this.plugin.getConfig().set("task_manager.end_when_one_left", (Object)cur);
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7eEnd When One Runner Left: " + (cur ? "\u00a7aON" : "\u00a7cOFF"));
                return true;
            }
            case "reload": {
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                try {
                    this.plugin.getTaskConfigManager().reloadConfig();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                tmm.reloadTasksFromFile();
                sender.sendMessage("\u00a7a[Task Manager] tasks.yml reloaded without restart!");
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown tasks subcommand. Use list|enable|disable|difficulty|reroll|endwhenoneleft|reload");
        return false;
    }

    private boolean handleClearTeams(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        LinkedHashSet<Player> affected = new LinkedHashSet<Player>();
        affected.addAll(this.plugin.getGameManager().getRunners());
        affected.addAll(this.plugin.getGameManager().getHunters());
        this.plugin.getGameManager().clearAllTeams();
        sender.sendMessage("\u00a7aCleared all teams (runners and hunters).");
        for (Player target : affected) {
            if (target == null || !target.isOnline() || target == sender) continue;
            target.sendMessage("\u00a7eYour team assignment was cleared by \u00a7f" + sender.getName() + "\u00a7e.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block22: {
            block26: {
                String current;
                block27: {
                    block25: {
                        block24: {
                            block23: {
                                block21: {
                                    completions = new ArrayList<String>();
                                    if (args.length != 1) break block21;
                                    List<String> subCommands = Arrays.asList("start", "stop", "pause", "resume", "status", "creator", "setrunners", "sethunters", "reload", "gui", "mode", "clearteams", "tasks", "complete", "interval", "randomize", "help");
                                    for (String subCommand : subCommands) {
                                        if (!subCommand.startsWith(args[0].toLowerCase())) continue;
                                        completions.add(subCommand);
                                    }
                                    break block22;
                                }
                                if (args.length <= 1) break block22;
                                if (!args[0].equalsIgnoreCase("setrunners") && !args[0].equalsIgnoreCase("sethunters")) break block23;
                                for (Player player : Bukkit.getOnlinePlayers()) {
                                    String name = player.getName();
                                    if (!name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                                    completions.add(name);
                                }
                                break block22;
                            }
                            if (!args[0].equalsIgnoreCase("complete") || args.length != 2) break block24;
                            if (!"confirm".startsWith(args[1].toLowerCase())) break block22;
                            completions.add("confirm");
                            break block22;
                        }
                        if (!args[0].equalsIgnoreCase("mode") || args.length != 2) break block25;
                        String[] stringArray = new String[]{"dream", "sapnap", "task"};
                        int n = stringArray.length;
                        int subCommand = 0;
                        while (subCommand < n) {
                            String opt = stringArray[subCommand];
                            if (opt.startsWith(args[1].toLowerCase())) {
                                completions.add(opt);
                            }
                            ++subCommand;
                        }
                        if (!"--force".startsWith(args[1].toLowerCase())) break block22;
                        completions.add("--force");
                        break block22;
                    }
                    if (!args[0].equalsIgnoreCase("mode") || args.length < 3) break block26;
                    current = args[args.length - 1].toLowerCase();
                    if (!"--force".startsWith(current)) break block27;
                    completions.add("--force");
                    break block22;
                }
                if (!"-f".startsWith(current)) break block22;
                completions.add("-f");
                break block22;
            }
            if (args[0].equalsIgnoreCase("randomize") && args.length == 2) {
                String[] stringArray = new String[]{"on", "off"};
                int n = stringArray.length;
                int subCommand = 0;
                while (subCommand < n) {
                    String opt = stringArray[subCommand];
                    if (opt.startsWith(args[1].toLowerCase())) {
                        completions.add(opt);
                    }
                    ++subCommand;
                }
            } else if (args[0].equalsIgnoreCase("tasks")) {
                if (args.length == 2) {
                    String[] stringArray = new String[]{"list", "enable", "disable", "difficulty", "reload", "reroll", "endwhenoneleft"};
                    int n = stringArray.length;
                    int subCommand = 0;
                    while (subCommand < n) {
                        String opt = stringArray[subCommand];
                        if (opt.startsWith(args[1].toLowerCase())) {
                            completions.add(opt);
                        }
                        ++subCommand;
                    }
                } else if (args.length == 3 && (args[1].equalsIgnoreCase("enable") || args[1].equalsIgnoreCase("disable"))) {
                    try {
                        Map<String, TaskDefinition> defs = this.plugin.getTaskManagerMode().getAllDefinitions();
                        for (String id : defs.keySet()) {
                            if (!id.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                            completions.add(id);
                        }
                    }
                    catch (Throwable defs) {}
                } else if (args.length == 3 && args[1].equalsIgnoreCase("difficulty")) {
                    String[] stringArray = new String[]{"easy", "medium", "hard"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String lvl = stringArray[n2];
                        if (lvl.startsWith(args[2].toLowerCase())) {
                            completions.add(lvl);
                        }
                        ++n2;
                    }
                }
            }
        }
        return completions;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleTaskComplete(CommandSender sender, String[] rest) {
        String description;
        void player;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can complete tasks.");
            return false;
        }
        Player player2 = (Player)sender;
        if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.TASK) {
            sender.sendMessage("\u00a7cTask completion is only available in Task Manager mode.");
            return false;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cTasks can only be completed during an active game.");
            return false;
        }
        TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
        if (taskMode == null) {
            sender.sendMessage("\u00a7cTask Manager not initialized.");
            return false;
        }
        String assignedTask = taskMode.getAssignedTask((Player)player);
        if (assignedTask == null) {
            sender.sendMessage("\u00a7cYou don't have a task assigned. Join the game as a runner first.");
            return false;
        }
        TaskDefinition taskDef = taskMode.getTask(assignedTask);
        String string = description = taskDef != null ? taskDef.description() : assignedTask;
        if (rest.length == 0) {
            player.sendMessage("\u00a76========== \u00a7e\u00a7lYOUR TASK \u00a76==========");
            player.sendMessage("\u00a7f" + description);
            player.sendMessage("");
            player.sendMessage("\u00a7a\u00a7lTo complete your task:");
            player.sendMessage("\u00a7e/swap complete confirm");
            player.sendMessage("");
            player.sendMessage("\u00a77When you use this command, you will win the game!");
            player.sendMessage("\u00a77Only use it when you have actually finished your task.");
            player.sendMessage("\u00a76" + "=".repeat(35));
            return true;
        }
        String action = rest[0].toLowerCase();
        if (!"confirm".equals(action)) {
            sender.sendMessage("\u00a7cUse '/swap complete confirm' to complete your task, or '/swap complete' to see your task.");
            return false;
        }
        player.sendMessage("\u00a7a\u00a7lCongratulations! You completed your task:");
        player.sendMessage("\u00a7f" + description);
        taskMode.complete((Player)player);
        return true;
    }
}

