/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.game;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class LastStandManager {
    private final SpeedrunnerSwap plugin;

    public LastStandManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        if (!this.plugin.getConfigManager().isLastStandEnabled()) {
            return;
        }
        FileConfiguration config = this.plugin.getConfig();
        boolean updated = false;
        if (config.contains("last_stand.duration") && !config.contains("last_stand.duration_ticks")) {
            int seconds = Math.max(1, config.getInt("last_stand.duration", 300));
            config.set("last_stand.duration_ticks", (Object)(seconds * 20));
            updated = true;
        }
        if (!config.isInt("last_stand.duration_ticks")) {
            config.set("last_stand.duration_ticks", (Object)600);
            updated = true;
        }
        if (!config.isInt("last_stand.strength_amplifier")) {
            config.set("last_stand.strength_amplifier", (Object)1);
            updated = true;
        }
        if (!config.isInt("last_stand.speed_amplifier")) {
            config.set("last_stand.speed_amplifier", (Object)1);
            updated = true;
        }
        if (updated) {
            this.plugin.saveConfig();
        }
    }

    public void activateLastStand(Player lastRunner) {
        if (!this.plugin.getConfigManager().isLastStandEnabled()) {
            return;
        }
        int durationTicks = this.plugin.getConfigManager().getLastStandDuration();
        int strengthAmplifier = this.plugin.getConfigManager().getLastStandStrengthAmplifier();
        int speedAmplifier = this.plugin.getConfigManager().getLastStandSpeedAmplifier();
        lastRunner.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, durationTicks, strengthAmplifier));
        lastRunner.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, durationTicks, speedAmplifier));
        lastRunner.sendMessage("\u00a76\u00a7lLAST STAND ACTIVATED! \u00a7eYou've received Strength and Speed boosts!");
    }
}

