/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.task.TaskDifficulty;
import com.example.speedrunnerswap.task.TaskManagerMode;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class ChatInputHandler
implements Listener {
    private final SpeedrunnerSwap plugin;
    private final Map<UUID, InputState> activeInputs = new HashMap<UUID, InputState>();

    public ChatInputHandler(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
        this.registerPaperAsyncChatHook();
    }

    public void expectTaskId(Player player) {
        this.activeInputs.put(player.getUniqueId(), new InputState(InputState.Type.TASK_ID));
    }

    public void expectTaskDescription(Player player, String taskId) {
        InputState state = new InputState(InputState.Type.TASK_DESCRIPTION);
        state.taskId = taskId;
        this.activeInputs.put(player.getUniqueId(), state);
    }

    public void expectTaskDescription(Player player) {
        this.activeInputs.put(player.getUniqueId(), new InputState(InputState.Type.TASK_DESCRIPTION));
    }

    public void expectConfigString(Player player, String path) {
        InputState st = new InputState(InputState.Type.CONFIG_STRING);
        st.configPath = path;
        this.activeInputs.put(player.getUniqueId(), st);
    }

    public void expectConfigListAdd(Player player, String path) {
        InputState st = new InputState(InputState.Type.CONFIG_LIST_ADD);
        st.configPath = path;
        this.activeInputs.put(player.getUniqueId(), st);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.activeInputs.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        String msg = event.getMessage();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleInput(player, msg));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.activeInputs.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.activeInputs.remove(event.getPlayer().getUniqueId());
    }

    private void handleInput(Player player, String rawMessage) {
        UUID uuid = player.getUniqueId();
        InputState state = this.activeInputs.remove(uuid);
        if (state == null) {
            return;
        }
        String msg = rawMessage == null ? "" : rawMessage.trim();
        switch (state.type) {
            case TASK_ID: {
                if ("cancel".equalsIgnoreCase(msg)) {
                    player.sendMessage("\u00a7cTask creation cancelled.");
                    return;
                }
                if (msg.isEmpty()) {
                    player.sendMessage("\u00a7cTask ID cannot be empty. Try again.");
                    this.expectTaskId(player);
                    return;
                }
                String id = msg.trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_]+", "_");
                if (id.isBlank()) {
                    player.sendMessage("\u00a7cTask ID must contain letters or numbers. Try again.");
                    this.expectTaskId(player);
                    return;
                }
                TaskManagerMode mode = this.plugin.getTaskManagerMode();
                if (mode != null && mode.isTask(id)) {
                    player.sendMessage("\u00a7cA task with that ID already exists. Use a different ID.");
                    this.expectTaskId(player);
                    return;
                }
                this.expectTaskDescription(player, id);
                player.sendMessage("\u00a76Enter a \u00a7bdescription \u00a76for task \u00a7e" + id + "\u00a76. Type \u00a7cCancel \u00a76to abort.");
                break;
            }
            case TASK_DESCRIPTION: {
                String id;
                if ("cancel".equalsIgnoreCase(msg)) {
                    player.sendMessage("\u00a7cTask creation cancelled.");
                    return;
                }
                String string = id = state.taskId != null && !state.taskId.isBlank() ? state.taskId.trim() : "custom_" + System.currentTimeMillis();
                if (msg.isEmpty()) {
                    player.sendMessage("\u00a7cDescription cannot be empty. Please enter a description.");
                    this.expectTaskDescription(player, id);
                    return;
                }
                InputState next = new InputState(InputState.Type.TASK_DIFFICULTY);
                next.taskId = id;
                next.taskDescription = msg;
                this.activeInputs.put(uuid, next);
                player.sendMessage("\u00a76Select a difficulty for \u00a7e" + id + "\u00a76. Type \u00a7aEasy\u00a76, \u00a7eMedium\u00a76, or \u00a7cHard\u00a76. Type \u00a7cCancel \u00a76to abort.");
                break;
            }
            case TASK_DIFFICULTY: {
                TaskDifficulty difficulty;
                if ("cancel".equalsIgnoreCase(msg)) {
                    player.sendMessage("\u00a7cTask creation cancelled.");
                    return;
                }
                try {
                    difficulty = TaskDifficulty.valueOf(msg.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage("\u00a7cInvalid difficulty. Please type Easy, Medium, or Hard.");
                    InputState retry = new InputState(InputState.Type.TASK_DIFFICULTY);
                    retry.taskId = state.taskId;
                    retry.taskDescription = state.taskDescription;
                    this.activeInputs.put(uuid, retry);
                    return;
                }
                String id = state.taskId != null && !state.taskId.isBlank() ? state.taskId.trim() : "custom_" + System.currentTimeMillis();
                String description = state.taskDescription != null ? state.taskDescription : "";
                TaskManagerMode mode = this.plugin.getTaskManagerMode();
                if (mode == null) {
                    player.sendMessage("\u00a7cTask Manager is not initialised. Try again later.");
                    return;
                }
                mode.addCustomTask(id, description, difficulty);
                player.sendMessage("\u00a7aAdded custom task \u00a7e" + id + " \u00a77(" + difficulty.name().toLowerCase(Locale.ROOT) + ")\u00a7a.");
                this.plugin.getGuiManager().openTaskManagerMenu(player);
                break;
            }
            case CONFIG_STRING: {
                if ("__dynamic__".equals(state.configPath)) {
                    if ("cancel".equalsIgnoreCase(msg)) {
                        player.sendMessage("\u00a7cConfig edit cancelled.");
                        return;
                    }
                    int idx = msg.indexOf(61);
                    if (idx <= 0 || idx == msg.length() - 1) {
                        player.sendMessage("\u00a7cUsage: path=value (example: swap.interval=75)");
                        this.expectConfigString(player, "__dynamic__");
                        return;
                    }
                    String rawPath = msg.substring(0, idx).trim();
                    String rawValue = msg.substring(idx + 1).trim();
                    Object parsed = this.parseValue(rawValue);
                    this.plugin.getConfig().set(rawPath, parsed);
                    this.plugin.saveConfig();
                    player.sendMessage("\u00a7aUpdated \u00a7e" + rawPath + "\u00a7a to \u00a7f" + rawValue + "\u00a7a.");
                    return;
                }
                this.plugin.getConfig().set(state.configPath, (Object)msg);
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aUpdated \u00a7e" + state.configPath + "\u00a7a.");
                break;
            }
            case CONFIG_LIST_ADD: {
                String value = msg;
                if ("safe_swap.dangerous_blocks".equalsIgnoreCase(state.configPath)) {
                    value = msg.toUpperCase(Locale.ROOT).trim();
                    Material material = Material.matchMaterial((String)value);
                    if (material == null) {
                        player.sendMessage("\u00a7cUnknown block '" + msg + "'. Addition cancelled.");
                        return;
                    }
                    value = material.name();
                }
                List list = this.plugin.getConfig().getStringList(state.configPath);
                list.add(value);
                this.plugin.getConfig().set(state.configPath, (Object)list);
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aAppended to \u00a7e" + state.configPath + "\u00a7a.");
                if (!"safe_swap.dangerous_blocks".equalsIgnoreCase(state.configPath)) break;
                this.plugin.getGuiManager().openDangerousBlocksMenu(player);
            }
        }
    }

    private Object parseValue(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(value);
        }
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }

    private void registerPaperAsyncChatHook() {
        try {
            Class<?> asyncChatCls = Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            EventExecutor exec = (listener, event) -> {
                String msgTmp;
                Player playerTmp;
                if (!asyncChatCls.isInstance(event)) {
                    return;
                }
                Event ev = event;
                try {
                    Method getPlayer = asyncChatCls.getMethod("getPlayer", new Class[0]);
                    playerTmp = (Player)getPlayer.invoke((Object)ev, new Object[0]);
                }
                catch (Throwable t) {
                    return;
                }
                try {
                    Method messageM = asyncChatCls.getMethod("message", new Class[0]);
                    Object component = messageM.invoke((Object)ev, new Object[0]);
                    Class<?> serCls = Class.forName("net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer");
                    Method plainText = serCls.getMethod("plainText", new Class[0]);
                    Object serializer = plainText.invoke(null, new Object[0]);
                    Method serialize = serializer.getClass().getMethod("serialize", Class.forName("net.kyori.adventure.text.Component"));
                    Object s = serialize.invoke(serializer, component);
                    msgTmp = s != null ? String.valueOf(s) : "";
                }
                catch (Throwable t) {
                    msgTmp = "";
                }
                Player player = playerTmp;
                String msg = msgTmp;
                try {
                    Method setCancelled = asyncChatCls.getMethod("setCancelled", Boolean.TYPE);
                    setCancelled.invoke((Object)ev, true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleInput(player, msg));
            };
            this.plugin.getServer().getPluginManager().registerEvent(asyncChatCls, (Listener)this, EventPriority.NORMAL, exec, (Plugin)this.plugin, true);
            this.plugin.getLogger().info("Paper AsyncChatEvent hook enabled.");
        }
        catch (ClassNotFoundException asyncChatCls) {
        }
        catch (Throwable t) {
            this.plugin.getLogger().warning("Failed to enable Paper AsyncChatEvent hook: " + t.getMessage());
        }
    }

    public void clearInput(Player player) {
        this.activeInputs.remove(player.getUniqueId());
    }

    private static class InputState {
        final Type type;
        String taskId;
        String taskDescription;
        String configPath;

        InputState(Type type) {
            this.type = type;
        }

        static enum Type {
            TASK_ID,
            TASK_DESCRIPTION,
            TASK_DIFFICULTY,
            CONFIG_STRING,
            CONFIG_LIST_ADD;

        }
    }
}

