/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.task;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TaskConfigManager {
    private final SpeedrunnerSwap plugin;
    private FileConfiguration taskConfig;
    private File taskConfigFile;

    public TaskConfigManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
        this.setup();
    }

    public void setup() {
        this.taskConfigFile = new File(this.plugin.getDataFolder(), "tasks.yml");
        if (!this.taskConfigFile.exists()) {
            try {
                this.plugin.saveResource("tasks.yml", false);
            }
            catch (IllegalArgumentException ignored) {
                try {
                    if (this.taskConfigFile.getParentFile() != null) {
                        this.taskConfigFile.getParentFile().mkdirs();
                    }
                    this.taskConfigFile.createNewFile();
                    this.taskConfig = new YamlConfiguration();
                    this.taskConfig.set("tasks", new ArrayList());
                    this.taskConfig.save(this.taskConfigFile);
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create tasks.yml", e);
                }
            }
        }
        this.taskConfig = YamlConfiguration.loadConfiguration((File)this.taskConfigFile);
    }

    public FileConfiguration getConfig() {
        return this.taskConfig;
    }

    public void saveConfig() {
        try {
            this.taskConfig.save(this.taskConfigFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save tasks.yml", e);
        }
    }

    public void reloadConfig() {
        this.taskConfig = YamlConfiguration.loadConfiguration((File)this.taskConfigFile);
    }
}

